/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.logging;

import java.util.concurrent.TimeUnit;

public enum TimeFormat {
    NANOS{

        @Override
        public String format(long nanos) {
            return String.valueOf(nanos) + TimeFormat.UNIT_NANOS;
        }
    }
    ,
    MILLIS{

        @Override
        public String format(long nanos) {
            return String.valueOf(TimeUnit.NANOSECONDS.toMillis(nanos)) + TimeFormat.UNIT_MILLIS;
        }
    }
    ,
    SECONDS{

        @Override
        public String format(long nanos) {
            return String.valueOf(TimeUnit.NANOSECONDS.toSeconds(nanos)) + TimeFormat.UNIT_SECONDS;
        }
    }
    ,
    MINUTES{

        @Override
        public String format(long nanos) {
            return String.valueOf(TimeUnit.NANOSECONDS.toMinutes(nanos)) + TimeFormat.UNIT_MINUTES;
        }
    }
    ,
    HOURS{

        @Override
        public String format(long nanos) {
            return String.valueOf(TimeUnit.NANOSECONDS.toHours(nanos)) + TimeFormat.UNIT_HOURS;
        }
    }
    ,
    SECONDS_AND_MILLIS{

        @Override
        public String format(long nanos) {
            long seconds = TimeUnit.NANOSECONDS.toSeconds(nanos);
            if (seconds == 0L) {
                return MILLIS.format(nanos);
            }
            return SECONDS.format(nanos) + " " + MILLIS.format(nanos - TimeUnit.SECONDS.toNanos(seconds));
        }
    }
    ,
    MINUTES_AND_SECONDS{

        @Override
        public String format(long nanos) {
            long minutes = TimeUnit.NANOSECONDS.toMinutes(nanos);
            if (minutes == 0L) {
                return SECONDS.format(nanos);
            }
            return MINUTES.format(nanos) + " " + SECONDS.format(nanos - TimeUnit.MINUTES.toNanos(minutes));
        }
    }
    ,
    UP_TO_MILLIS{

        @Override
        public String format(long nanos) {
            long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
            if (millis == 0L) {
                return NANOS.format(nanos);
            }
            return MILLIS.format(nanos) + " " + NANOS.format(nanos - TimeUnit.MILLISECONDS.toNanos(millis));
        }
    }
    ,
    UP_TO_SECONDS{

        @Override
        public String format(long nanos) {
            long seconds = TimeUnit.NANOSECONDS.toSeconds(nanos);
            long diff = nanos - TimeUnit.SECONDS.toNanos(seconds);
            long millis = TimeUnit.NANOSECONDS.toMillis(diff);
            if (seconds == 0L) {
                if (millis == 0L) {
                    return NANOS.format(nanos);
                }
                return UP_TO_MILLIS.format(nanos);
            }
            return SECONDS.format(nanos) + " " + UP_TO_MILLIS.format(diff);
        }
    }
    ,
    UP_TO_MINUTES{

        @Override
        public String format(long nanos) {
            long minutes = TimeUnit.NANOSECONDS.toMinutes(nanos);
            long diff = nanos - TimeUnit.MINUTES.toNanos(minutes);
            long seconds = TimeUnit.NANOSECONDS.toSeconds(diff);
            long millis = TimeUnit.NANOSECONDS.toMillis(diff - TimeUnit.SECONDS.toNanos(seconds));
            if (minutes == 0L) {
                if (seconds == 0L) {
                    if (millis == 0L) {
                        return NANOS.format(nanos);
                    }
                    return UP_TO_MILLIS.format(nanos);
                }
                return UP_TO_SECONDS.format(nanos);
            }
            return MINUTES.format(nanos) + " " + UP_TO_SECONDS.format(diff);
        }
    }
    ,
    UP_TO_HOURS{

        @Override
        public String format(long nanos) {
            long hours = TimeUnit.NANOSECONDS.toHours(nanos);
            long diff = nanos - TimeUnit.HOURS.toNanos(hours);
            long minutes = TimeUnit.NANOSECONDS.toMinutes(diff);
            long diff1 = diff - TimeUnit.MINUTES.toNanos(minutes);
            long seconds = TimeUnit.NANOSECONDS.toSeconds(diff1);
            long millis = TimeUnit.NANOSECONDS.toMillis(diff1 - TimeUnit.SECONDS.toNanos(seconds));
            if (hours == 0L) {
                if (minutes == 0L) {
                    if (seconds == 0L) {
                        if (millis == 0L) {
                            return NANOS.format(nanos);
                        }
                        return UP_TO_MILLIS.format(nanos);
                    }
                    return UP_TO_SECONDS.format(nanos);
                }
                return UP_TO_MINUTES.format(nanos);
            }
            return HOURS.format(nanos) + " " + UP_TO_MINUTES.format(diff);
        }
    };

    private static final String UNIT_HOURS = "h";
    private static final String UNIT_MINUTES = "m";
    private static final String UNIT_SECONDS = "s";
    private static final String UNIT_MILLIS = "ms";
    private static final String UNIT_NANOS = "ns";

    public String format(long nanos) {
        return String.valueOf(nanos);
    }
}

