/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.logging;

import it.unive.lisa.logging.TimeFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public final class TimerLogger {
    private TimerLogger() {
    }

    public static void execAction(Logger logger, String message, LoggableAction action) {
        TimerLogger.execAction(logger, Level.INFO, TimeFormat.UP_TO_MINUTES, message, action);
    }

    public static void execAction(Logger logger, Level logLevel, String message, LoggableAction action) {
        TimerLogger.execAction(logger, logLevel, TimeFormat.UP_TO_MINUTES, message, action);
    }

    public static void execAction(Logger logger, Level logLevel, TimeFormat formatter, String message, LoggableAction action) {
        TimerLogger.execAux(logger, logLevel, formatter, message, action);
    }

    public static <T> T execSupplier(Logger logger, String message, LoggableSupplier<T> supplier) {
        return TimerLogger.execSupplier(logger, Level.INFO, TimeFormat.UP_TO_MINUTES, message, supplier);
    }

    public static <T> T execSupplier(Logger logger, Level logLevel, String message, LoggableSupplier<T> supplier) {
        return TimerLogger.execSupplier(logger, logLevel, TimeFormat.UP_TO_MINUTES, message, supplier);
    }

    public static <T> T execSupplier(Logger logger, Level logLevel, TimeFormat formatter, String message, LoggableSupplier<T> supplier) {
        Wrapper w = new Wrapper();
        TimerLogger.execAux(logger, logLevel, formatter, message, () -> {
            w.ret = supplier.run();
        });
        return w.ret;
    }

    private static void execAux(Logger logger, Level logLevel, TimeFormat formatter, String message, LoggableAction action) {
        long startTime = System.nanoTime();
        logger.log(logLevel, "{} [start]", (Object)message);
        action.run();
        logger.log(logLevel, "{} [stop] [completed in {}]", (Object)message, (Object)formatter.format(System.nanoTime() - startTime));
    }

    @FunctionalInterface
    public static interface LoggableSupplier<R> {
        public R run();
    }

    @FunctionalInterface
    public static interface LoggableAction {
        public void run();
    }

    private static class Wrapper<T> {
        private T ret;

        private Wrapper() {
        }
    }
}

