/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import it.unive.lisa.checks.warnings.Warning;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class JsonReport {
    private final Set<JsonWarning> warnings = new TreeSet<JsonWarning>();
    private final Set<String> files;

    public JsonReport() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public JsonReport(Collection<Warning> warnings, Collection<String> files) {
        this.files = new TreeSet<String>(files);
        for (Warning warn : warnings) {
            this.warnings.add(new JsonWarning(warn));
        }
    }

    public Collection<JsonWarning> getWarnings() {
        return this.warnings;
    }

    public Collection<String> getFiles() {
        return this.files;
    }

    public void dump(Writer writer) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.writeValue(writer, (Object)this);
    }

    public static JsonReport read(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JsonReport)mapper.readValue(reader, JsonReport.class);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.files == null ? 0 : this.files.hashCode());
        result = 31 * result + (this.warnings == null ? 0 : this.warnings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonReport other = (JsonReport)obj;
        if (this.files == null ? other.files != null : !this.files.equals(other.files)) {
            return false;
        }
        return !(this.warnings == null ? other.warnings != null : !this.warnings.equals(other.warnings));
    }

    public String toString() {
        return "JsonAnalysisReport [findings=" + this.warnings + ", files=" + this.files + "]";
    }

    public static class JsonWarning
    implements Comparable<JsonWarning> {
        private String message;

        public JsonWarning() {
            this.message = null;
        }

        public JsonWarning(Warning warning) {
            this.message = warning.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return this.getMessage();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JsonWarning other = (JsonWarning)obj;
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        @Override
        public int compareTo(JsonWarning o) {
            return this.message.compareTo(o.message);
        }
    }
}

