/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.compare;

import it.unive.lisa.outputs.DotGraph;
import it.unive.lisa.outputs.JsonReport;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;

public class JsonReportComparer {
    public static boolean compare(JsonReport first, JsonReport second, File firstFileRoot, File secondFileRoot) throws IOException {
        return JsonReportComparer.compare(first, second, firstFileRoot, secondFileRoot, new BaseDiffReporter());
    }

    public static boolean compare(JsonReport first, JsonReport second, File firstFileRoot, File secondFileRoot, DiffReporter reporter) throws IOException {
        CollectionsDiffBuilder<JsonReport.JsonWarning> warnings = new CollectionsDiffBuilder<JsonReport.JsonWarning>(JsonReport.JsonWarning.class, first.getWarnings(), second.getWarnings());
        warnings.compute(JsonReport.JsonWarning::compareTo);
        if (!warnings.getCommons().isEmpty()) {
            reporter.report(REPORTED_COMPONENT.WARNINGS, REPORT_TYPE.COMMON, warnings.getCommons());
        }
        if (!warnings.getOnlyFirst().isEmpty()) {
            reporter.report(REPORTED_COMPONENT.WARNINGS, REPORT_TYPE.ONLY_FIRST, warnings.getOnlyFirst());
        }
        if (!warnings.getOnlySecond().isEmpty()) {
            reporter.report(REPORTED_COMPONENT.WARNINGS, REPORT_TYPE.ONLY_SECOND, warnings.getOnlySecond());
        }
        CollectionsDiffBuilder<String> files = new CollectionsDiffBuilder<String>(String.class, first.getFiles(), second.getFiles());
        files.compute(String::compareTo);
        if (!files.getCommons().isEmpty()) {
            reporter.report(REPORTED_COMPONENT.FILES, REPORT_TYPE.COMMON, files.getCommons());
        }
        if (!files.getOnlyFirst().isEmpty()) {
            reporter.report(REPORTED_COMPONENT.FILES, REPORT_TYPE.ONLY_FIRST, files.getOnlyFirst());
        }
        if (!files.getOnlySecond().isEmpty()) {
            reporter.report(REPORTED_COMPONENT.FILES, REPORT_TYPE.ONLY_SECOND, files.getOnlySecond());
        }
        if (!warnings.sameContent() || !files.sameContent()) {
            return false;
        }
        boolean diffFound = false;
        for (Pair<String, String> pair : files.getCommons()) {
            File left = new File(firstFileRoot, (String)pair.getLeft());
            if (!left.exists()) {
                throw new FileNotFoundException((String)pair.getLeft() + " declared as output in the first report does not exist");
            }
            File right = new File(secondFileRoot, (String)pair.getRight());
            if (!right.exists()) {
                throw new FileNotFoundException((String)pair.getRight() + " declared as output in the second report does not exist");
            }
            if (!left.getName().endsWith(".dot") || JsonReportComparer.matchDotGraphs(left, right)) continue;
            reporter.fileDiff(left.toString(), right.toString(), "Graphs are different");
            diffFound = true;
        }
        return !diffFound;
    }

    private static boolean matchDotGraphs(File left, File right) throws IOException {
        try (InputStreamReader l = new InputStreamReader((InputStream)new FileInputStream(left), StandardCharsets.UTF_8);){
            boolean bl;
            try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(right), StandardCharsets.UTF_8);){
                DotGraph lDot = DotGraph.readDot(l);
                DotGraph rDot = DotGraph.readDot(r);
                bl = lDot.equals(rDot);
            }
            return bl;
        }
    }

    private static class BaseDiffReporter
    implements DiffReporter {
        private BaseDiffReporter() {
        }

        @Override
        public void report(REPORTED_COMPONENT component, REPORT_TYPE type, Collection<?> reported) {
            if (type == REPORT_TYPE.COMMON) {
                return;
            }
            boolean isFirst = type == REPORT_TYPE.ONLY_FIRST;
            switch (component) {
                case FILES: {
                    if (isFirst) {
                        System.err.println("Files only in the first report:");
                        break;
                    }
                    System.err.println("Files only in the second report:");
                    break;
                }
                case WARNINGS: {
                    if (isFirst) {
                        System.err.println("Warnings only in the first report:");
                        break;
                    }
                    System.err.println("Warnings only in the second report:");
                    break;
                }
            }
            for (Object o : reported) {
                System.err.println("\t" + o);
            }
        }

        @Override
        public void fileDiff(String first, String second, String message) {
            System.err.println("['" + first + "', '" + second + "'] " + message);
        }
    }

    public static interface DiffReporter {
        public void report(REPORTED_COMPONENT var1, REPORT_TYPE var2, Collection<?> var3);

        public void fileDiff(String var1, String var2, String var3);
    }

    public static enum REPORTED_COMPONENT {
        WARNINGS,
        FILES;

    }

    public static enum REPORT_TYPE {
        COMMON,
        ONLY_FIRST,
        ONLY_SECOND;

    }
}

