/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.CodeElement;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Objects;

public class Global
implements CodeElement {
    private final String name;
    private final Type staticType;
    private final CodeLocation location;
    private final Annotations annotations;

    public Global(CodeLocation location, String name) {
        this(location, name, Untyped.INSTANCE);
    }

    public Global(CodeLocation location, String name, Type staticType) {
        this(location, name, staticType, new Annotations());
    }

    public Global(CodeLocation location, String name, Type staticType, Annotations annotations) {
        Objects.requireNonNull(name, "The name of a parameter cannot be null");
        Objects.requireNonNull(staticType, "The type of a parameter cannot be null");
        Objects.requireNonNull(location, "The location of a parameter cannot be null");
        this.location = location;
        this.name = name;
        this.staticType = staticType;
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public Type getStaticType() {
        return this.staticType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.staticType == null ? 0 : this.staticType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Global other = (Global)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.staticType == null ? other.staticType != null : !this.staticType.equals(other.staticType));
    }

    public String toString() {
        return this.staticType + " " + this.name;
    }

    @Override
    public CodeLocation getLocation() {
        return this.location;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.addAnnotation(ann);
    }
}

