/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.cfg.CodeLocation;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SourceCodeLocation
implements CodeLocation {
    private final String sourceFile;
    private final int line;
    private final int col;

    public SourceCodeLocation(String sourceFile, int line, int col) {
        Objects.requireNonNull(sourceFile, "The source file cannot be null");
        if (line == -1) {
            throw new IllegalArgumentException("Line number cannot be negative");
        }
        if (col == -1) {
            throw new IllegalArgumentException("Column number cannot be negative");
        }
        this.sourceFile = FilenameUtils.separatorsToUnix((String)sourceFile);
        this.line = line;
        this.col = col;
    }

    @Override
    public String getCodeLocation() {
        return "'" + this.sourceFile + "':" + this.line + ":" + this.col;
    }

    public final String getSourceFile() {
        return String.valueOf(this.sourceFile);
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCol() {
        return this.col;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        result = 31 * result + this.line;
        result = 31 * result + (this.sourceFile == null ? 0 : this.sourceFile.hashCode());
        return result;
    }

    public String toString() {
        return "'" + this.sourceFile + "':" + this.line + ":" + this.col;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceCodeLocation other = (SourceCodeLocation)obj;
        if (this.col != other.col) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        return !(this.sourceFile == null ? other.sourceFile != null : !this.sourceFile.equals(other.sourceFile));
    }

    @Override
    public int compareTo(CodeLocation other) {
        if (!(other instanceof SourceCodeLocation)) {
            return -1;
        }
        SourceCodeLocation o = (SourceCodeLocation)other;
        int cmp = StringUtils.compare((String)this.getSourceFile(), (String)o.getSourceFile());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.getLine(), o.getLine());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.getCol(), o.getCol());
    }
}

