/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg;

import it.unive.lisa.program.CodeElement;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Objects;

public class Parameter
implements CodeElement {
    private final String name;
    private final Type staticType;
    private final CodeLocation location;
    private final Annotations annotations;
    private final Expression defaultValue;

    public Parameter(CodeLocation location, String name) {
        this(location, name, Untyped.INSTANCE, null, new Annotations());
    }

    public Parameter(CodeLocation location, String name, Type staticType) {
        this(location, name, staticType, null, new Annotations());
    }

    public Parameter(CodeLocation location, String name, Expression defaultValue) {
        this(location, name, defaultValue.getStaticType(), defaultValue, new Annotations());
    }

    public Parameter(CodeLocation location, String name, Type staticType, Expression defaultValue, Annotations annotations) {
        Objects.requireNonNull(name, "The name of a parameter cannot be null");
        Objects.requireNonNull(staticType, "The type of a parameter cannot be null");
        Objects.requireNonNull(location, "The location of a CFG cannot be null");
        this.location = location;
        this.name = name;
        this.staticType = staticType;
        this.annotations = annotations;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public Type getStaticType() {
        return this.staticType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.staticType == null ? 0 : this.staticType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.staticType == null ? other.staticType != null : !this.staticType.equals(other.staticType)) {
            return false;
        }
        return !(this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations));
    }

    public String toString() {
        return this.staticType + " " + this.name;
    }

    @Override
    public CodeLocation getLocation() {
        return this.location;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.addAnnotation(ann);
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public Variable toSymbolicVariable() {
        return new Variable(this.staticType, this.name, this.annotations, this.location);
    }
}

