/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg;

import it.unive.lisa.program.CodeElement;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.VariableRef;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Objects;

public class VariableTableEntry
implements CodeElement {
    private int index;
    private final String name;
    private final Type staticType;
    private Statement scopeStart;
    private Statement scopeEnd;
    private final CodeLocation location;
    private final Annotations annotations;

    public VariableTableEntry(CodeLocation location, int index, String name) {
        this(location, index, null, null, name, Untyped.INSTANCE);
    }

    public VariableTableEntry(CodeLocation location, int index, Statement scopeStart, Statement scopeEnd, String name) {
        this(location, index, scopeStart, scopeEnd, name, Untyped.INSTANCE);
    }

    public VariableTableEntry(CodeLocation location, int index, Statement scopeStart, Statement scopeEnd, String name, Type staticType) {
        this(location, index, scopeStart, scopeEnd, name, staticType, new Annotations());
    }

    public VariableTableEntry(CodeLocation location, int index, Statement scopeStart, Statement scopeEnd, String name, Type staticType, Annotations annotations) {
        Objects.requireNonNull(name, "The name of a variable cannot be null");
        Objects.requireNonNull(staticType, "The type of a variable cannot be null");
        Objects.requireNonNull(location, "The location of a variable cannot be null");
        this.location = location;
        this.index = index;
        this.name = name;
        this.staticType = staticType;
        this.scopeStart = scopeStart;
        this.scopeEnd = scopeEnd;
        this.annotations = annotations;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Statement getScopeStart() {
        return this.scopeStart;
    }

    public void setScopeStart(Statement scopeStart) {
        this.scopeStart = scopeStart;
    }

    public Statement getScopeEnd() {
        return this.scopeEnd;
    }

    public void setScopeEnd(Statement scopeEnd) {
        this.scopeEnd = scopeEnd;
    }

    public String getName() {
        return this.name;
    }

    public Type getStaticType() {
        return this.staticType;
    }

    public VariableRef createReference(CFG cfg) {
        return new VariableRef(cfg, cfg.getDescriptor().getLocation(), this.name, this.staticType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.scopeEnd == null ? 0 : this.scopeEnd.hashCode());
        result = 31 * result + (this.scopeStart == null ? 0 : this.scopeStart.hashCode());
        result = 31 * result + (this.staticType == null ? 0 : this.staticType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableTableEntry other = (VariableTableEntry)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.scopeEnd == null ? other.scopeEnd != null : !this.scopeEnd.equals(other.scopeEnd)) {
            return false;
        }
        if (this.scopeStart == null ? other.scopeStart != null : !this.scopeStart.equals(other.scopeStart)) {
            return false;
        }
        return !(this.staticType == null ? other.staticType != null : !this.staticType.equals(other.staticType));
    }

    public String toString() {
        return "[" + this.index + "] " + this.staticType + " " + this.name;
    }

    @Override
    public CodeLocation getLocation() {
        return this.location;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.addAnnotation(ann);
    }
}

