/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.controlFlow;

import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.controlFlow.ControlFlowStructure;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.NoOp;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.datastructures.graph.AdjacencyMatrix;
import java.util.Collection;
import java.util.HashSet;

public class IfThenElse
extends ControlFlowStructure {
    private final Collection<Statement> trueBranch;
    private final Collection<Statement> falseBranch;

    public IfThenElse(AdjacencyMatrix<Statement, Edge, CFG> cfgMatrix, Statement condition, Statement firstFollower, Collection<Statement> trueBranch, Collection<Statement> falseBranch) {
        super(cfgMatrix, condition, firstFollower);
        this.trueBranch = trueBranch;
        this.falseBranch = falseBranch;
    }

    @Override
    public Collection<Statement> bodyStatements() {
        HashSet<Statement> all = new HashSet<Statement>(this.getTrueBranch());
        all.addAll(this.getFalseBranch());
        return all;
    }

    public Collection<Statement> getTrueBranch() {
        return this.trueBranch;
    }

    public Collection<Statement> getFalseBranch() {
        return this.falseBranch;
    }

    @Override
    public boolean contains(Statement st) {
        return this.trueBranch.contains(st) || this.falseBranch.contains(st);
    }

    @Override
    public void simplify() {
        this.trueBranch.removeIf(NoOp.class::isInstance);
        this.falseBranch.removeIf(NoOp.class::isInstance);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.falseBranch == null ? 0 : this.falseBranch.hashCode());
        result = 31 * result + (this.trueBranch == null ? 0 : this.trueBranch.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IfThenElse other = (IfThenElse)obj;
        if (this.falseBranch == null ? other.falseBranch != null : !this.falseBranch.equals(other.falseBranch)) {
            return false;
        }
        return !(this.trueBranch == null ? other.trueBranch != null : !this.trueBranch.equals(other.trueBranch));
    }

    @Override
    public String toString() {
        return "if-then-else[" + this.getCondition() + "]";
    }
}

