/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.edge;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.operator.unary.LogicalNegation;

public class FalseEdge
extends Edge {
    public FalseEdge(Statement source, Statement destination) {
        super(source, destination);
    }

    @Override
    public String toString() {
        return "[ " + this.getSource() + " ] -F-> [ " + this.getDestination() + " ]";
    }

    @Override
    public <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> traverse(AnalysisState<A, H, V, T> sourceState) throws SemanticException {
        ExpressionSet<SymbolicExpression> exprs = sourceState.getComputedExpressions();
        Lattice result = sourceState.bottom();
        for (SymbolicExpression expr : exprs) {
            SemanticDomain tmp = sourceState.assume(new UnaryExpression(expr.getStaticType(), expr, LogicalNegation.INSTANCE, expr.getCodeLocation()), (ProgramPoint)this.getSource());
            result = (AnalysisState)((BaseLattice)result).lub(tmp);
        }
        return result;
    }

    @Override
    public boolean canBeSimplified() {
        return false;
    }

    @Override
    public FalseEdge newInstance(Statement source, Statement destination) {
        return new FalseEdge(source, destination);
    }
}

