/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public abstract class Expression
extends Statement {
    private final Type staticType;
    private Statement parent;
    private final Collection<Identifier> metaVariables;

    protected Expression(CFG cfg, CodeLocation location) {
        this(cfg, location, Untyped.INSTANCE);
    }

    protected Expression(CFG cfg, CodeLocation location, Type staticType) {
        super(cfg, location);
        Objects.requireNonNull(staticType, "The expression type of a CFG cannot be null");
        this.staticType = staticType;
        this.metaVariables = new HashSet<Identifier>();
    }

    public final Type getStaticType() {
        return this.staticType;
    }

    public Collection<Identifier> getMetaVariables() {
        return this.metaVariables;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.staticType == null ? 0 : this.staticType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        return !(this.staticType == null ? other.staticType != null : !this.staticType.equals(other.staticType));
    }

    public final void setParentStatement(Statement st) {
        this.parent = st;
    }

    public final Statement getParentStatement() {
        if (this instanceof Call) {
            Call original = (Call)this;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            if (original != this) {
                return original.getParentStatement();
            }
        }
        return this.parent;
    }

    public final Statement getRootStatement() {
        if (this instanceof Call) {
            Call original = (Call)this;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            if (original != this) {
                return original.getRootStatement();
            }
        }
        if (this.parent == null) {
            return this;
        }
        if (!(this.parent instanceof Expression)) {
            return this.parent;
        }
        return ((Expression)this.parent).getRootStatement();
    }

    @Override
    protected Statement getStatementEvaluatedBefore(Statement other) {
        if (this instanceof Call) {
            Call original = (Call)this;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            if (original != this) {
                return original.getStatementEvaluatedBefore(other);
            }
        }
        if (other != this || this.parent == null) {
            return null;
        }
        return this.parent.getStatementEvaluatedBefore(this);
    }
}

