/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.program.cfg.statement.evaluation.LeftToRightEvaluation;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class NaryExpression
extends Expression {
    private final Expression[] subExpressions;
    private final String constructName;
    private final EvaluationOrder order;

    protected NaryExpression(CFG cfg, CodeLocation location, String constructName, Expression ... subExpressions) {
        this(cfg, location, constructName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, Untyped.INSTANCE, subExpressions);
    }

    protected NaryExpression(CFG cfg, CodeLocation location, String constructName, EvaluationOrder order, Expression ... subExpressions) {
        this(cfg, location, constructName, order, Untyped.INSTANCE, subExpressions);
    }

    protected NaryExpression(CFG cfg, CodeLocation location, String constructName, Type staticType, Expression ... subExpressions) {
        this(cfg, location, constructName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, staticType, subExpressions);
    }

    protected NaryExpression(CFG cfg, CodeLocation location, String constructName, EvaluationOrder order, Type staticType, Expression ... subExpressions) {
        super(cfg, location, staticType);
        Objects.requireNonNull(subExpressions, "The array of sub-expressions of an expression cannot be null");
        for (int i = 0; i < subExpressions.length; ++i) {
            Objects.requireNonNull(subExpressions[i], "The " + i + "-th sub-expression of an expression cannot be null");
        }
        Objects.requireNonNull(constructName, "The name of the native construct of an expression cannot be null");
        Objects.requireNonNull(order, "The evaluation order of an expression cannot be null");
        this.constructName = constructName;
        this.order = order;
        this.subExpressions = subExpressions;
        for (Expression param : subExpressions) {
            param.setParentStatement(this);
        }
    }

    public final String getConstructName() {
        return this.constructName;
    }

    public final Expression[] getSubExpressions() {
        return this.subExpressions;
    }

    public EvaluationOrder getOrder() {
        return this.order;
    }

    @Override
    public final int setOffset(int offset) {
        this.offset = offset;
        int off = offset;
        for (Expression sub : this.subExpressions) {
            off = sub.setOffset(off + 1);
        }
        return off;
    }

    @Override
    protected Statement getStatementEvaluatedBefore(Statement other) {
        int len = this.subExpressions.length;
        if (other == this) {
            return len == 0 ? null : this.subExpressions[this.order.last(len)];
        }
        for (int i = 0; i < len; ++i) {
            if (this.subExpressions[i] != other) continue;
            if (i == this.order.first(len)) {
                return null;
            }
            return this.subExpressions[this.order.previous(i, len)];
        }
        return null;
    }

    @Override
    public final <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        for (Expression sub : this.subExpressions) {
            if (sub.accept(visitor, tool)) continue;
            return false;
        }
        return visitor.visit(tool, this.getCFG(), (Edge)((Object)this));
    }

    @Override
    public String toString() {
        return this.constructName + "(" + StringUtils.join((Object[])this.getSubExpressions(), (String)", ") + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.constructName == null ? 0 : this.constructName.hashCode());
        result = 31 * result + Arrays.hashCode(this.subExpressions);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NaryExpression)) {
            return false;
        }
        NaryExpression other = (NaryExpression)obj;
        if (this.constructName == null ? other.constructName != null : !this.constructName.equals(other.constructName)) {
            return false;
        }
        return Arrays.equals(this.subExpressions, other.subExpressions);
    }

    @Override
    public final <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> semantics(AnalysisState<A, H, V, T> entryState, InterproceduralAnalysis<A, H, V, T> interprocedural, StatementStore<A, H, V, T> expressions) throws SemanticException {
        ExpressionSet[] computed = new ExpressionSet[this.subExpressions.length];
        AnalysisState<A, H, V, T> eval = this.order.evaluate(this.subExpressions, entryState, interprocedural, expressions, computed);
        AnalysisState result = this.expressionSemantics(interprocedural, eval, computed, expressions);
        for (Expression sub : this.subExpressions) {
            if (sub.getMetaVariables().isEmpty()) continue;
            result = (AnalysisState)result.forgetIdentifiers(sub.getMetaVariables());
        }
        return result;
    }

    public abstract <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> expressionSemantics(InterproceduralAnalysis<A, H, V, T> var1, AnalysisState<A, H, V, T> var2, ExpressionSet<SymbolicExpression>[] var3, StatementStore<A, H, V, T> var4) throws SemanticException;
}

