/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.MetaVariableCreator;
import it.unive.lisa.program.cfg.statement.UnaryStatement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Variable;

public class Return
extends UnaryStatement
implements MetaVariableCreator {
    public Return(CFG cfg, CodeLocation location, Expression expression) {
        super(cfg, location, expression);
    }

    @Override
    public final String toString() {
        return "return " + this.getExpression();
    }

    @Override
    public boolean stopsExecution() {
        return true;
    }

    @Override
    public final Identifier getMetaVariable() {
        Expression e = this.getExpression();
        String name = "ret_value@" + this.getCFG().getDescriptor().getName();
        Variable var = new Variable(e.getStaticType(), name, this.getLocation());
        return var;
    }

    @Override
    public <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> semantics(AnalysisState<A, H, V, T> entryState, InterproceduralAnalysis<A, H, V, T> interprocedural, StatementStore<A, H, V, T> expressions) throws SemanticException {
        AnalysisState<A, H, V, T> exprResult = this.getExpression().semantics(entryState, interprocedural, expressions);
        expressions.put(this.getExpression(), exprResult);
        Lattice result = entryState.bottom();
        Identifier meta = this.getMetaVariable();
        for (SymbolicExpression expr : exprResult.getComputedExpressions()) {
            SemanticDomain tmp = exprResult.assign(meta, expr, (ProgramPoint)this);
            result = (AnalysisState)((BaseLattice)result).lub(tmp);
        }
        if (!this.getExpression().getMetaVariables().isEmpty()) {
            result = (AnalysisState)result.forgetIdentifiers(this.getExpression().getMetaVariables());
        }
        return result;
    }
}

