/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.util.datastructures.graph.Node;
import java.util.Objects;

public abstract class Statement
implements Node<Statement, Edge, CFG>,
ProgramPoint,
Comparable<Statement> {
    private final CFG cfg;
    protected int offset;
    private final CodeLocation location;

    protected Statement(CFG cfg, CodeLocation location) {
        Objects.requireNonNull(cfg, "Containing CFG cannot be null");
        Objects.requireNonNull(location, "The location of a statement cannot be null");
        this.cfg = cfg;
        this.location = location;
        this.offset = -1;
    }

    @Override
    public final CFG getCFG() {
        return this.cfg;
    }

    public final int getOffset() {
        return this.offset;
    }

    public boolean stopsExecution() {
        return false;
    }

    public boolean throwsError() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Statement st = (Statement)obj;
        if (this.location == null) {
            if (st.location == null) {
                return true;
            }
        } else if (!this.location.equals(st.location)) {
            return false;
        }
        return true;
    }

    public abstract String toString();

    public abstract <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> semantics(AnalysisState<A, H, V, T> var1, InterproceduralAnalysis<A, H, V, T> var2, StatementStore<A, H, V, T> var3) throws SemanticException;

    @Override
    public CodeLocation getLocation() {
        return this.location;
    }

    @Override
    public int compareTo(Statement o) {
        return this.location.compareTo(o.location);
    }

    public final Statement getEvaluationPredecessor() {
        if (this instanceof Call) {
            Call original = (Call)this;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            if (original != this) {
                return this.getStatementEvaluatedBefore(original);
            }
        }
        return this.getStatementEvaluatedBefore(this);
    }

    protected Statement getStatementEvaluatedBefore(Statement other) {
        return null;
    }
}

