/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NaryExpression;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;

public abstract class TernaryExpression
extends NaryExpression {
    protected TernaryExpression(CFG cfg, CodeLocation location, String constructName, Expression left, Expression middle, Expression right) {
        super(cfg, location, constructName, left, middle, right);
    }

    protected TernaryExpression(CFG cfg, CodeLocation location, String constructName, Type staticType, Expression left, Expression middle, Expression right) {
        super(cfg, location, constructName, staticType, left, middle, right);
    }

    protected TernaryExpression(CFG cfg, CodeLocation location, String constructName, EvaluationOrder order, Expression left, Expression middle, Expression right) {
        super(cfg, location, constructName, order, left, middle, right);
    }

    protected TernaryExpression(CFG cfg, CodeLocation location, String constructName, EvaluationOrder order, Type staticType, Expression left, Expression middle, Expression right) {
        super(cfg, location, constructName, order, staticType, left, middle, right);
    }

    public Expression getLeft() {
        return this.getSubExpressions()[0];
    }

    public Expression getMiddle() {
        return this.getSubExpressions()[2];
    }

    public Expression getRight() {
        return this.getSubExpressions()[2];
    }

    @Override
    public final <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> expressionSemantics(InterproceduralAnalysis<A, H, V, T> interprocedural, AnalysisState<A, H, V, T> state, ExpressionSet<SymbolicExpression>[] params, StatementStore<A, H, V, T> expressions) throws SemanticException {
        AnalysisState<A, H, V, T> result = state.bottom();
        for (SymbolicExpression left : params[0]) {
            for (SymbolicExpression middle : params[1]) {
                for (SymbolicExpression right : params[2]) {
                    result = result.lub(this.ternarySemantics(interprocedural, state, left, middle, right, expressions));
                }
            }
        }
        return result;
    }

    protected abstract <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> ternarySemantics(InterproceduralAnalysis<A, H, V, T> var1, AnalysisState<A, H, V, T> var2, SymbolicExpression var3, SymbolicExpression var4, SymbolicExpression var5, StatementStore<A, H, V, T> var6) throws SemanticException;
}

