/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.MetaVariableCreator;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.CallWithResult;
import it.unive.lisa.program.cfg.statement.call.CanRemoveReceiver;
import it.unive.lisa.program.cfg.statement.call.TruncatedParamsCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.program.cfg.statement.call.assignment.ParameterAssigningStrategy;
import it.unive.lisa.program.cfg.statement.call.assignment.PythonLikeAssigningStrategy;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.program.cfg.statement.evaluation.LeftToRightEvaluation;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class CFGCall
extends CallWithResult
implements MetaVariableCreator,
CanRemoveReceiver {
    private final Collection<CFG> targets;

    public CFGCall(CFG cfg, CodeLocation location, Call.CallType callType, String qualifier, String targetName, Collection<CFG> targets, Expression ... parameters) {
        this(cfg, location, (ParameterAssigningStrategy)PythonLikeAssigningStrategy.INSTANCE, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, targets, parameters);
    }

    public CFGCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, Call.CallType callType, String qualifier, String targetName, Collection<CFG> targets, Expression ... parameters) {
        this(cfg, location, assigningStrategy, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, targets, parameters);
    }

    public CFGCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, Call.CallType callType, String qualifier, String targetName, EvaluationOrder order, Collection<CFG> targets, Expression ... parameters) {
        super(cfg, location, assigningStrategy, callType, qualifier, targetName, order, CFGCall.getCommonReturnType(targets), parameters);
        Objects.requireNonNull(targets, "The targets of a CFG call cannot be null");
        for (CFG target : targets) {
            Objects.requireNonNull(target, "A target of a CFG call cannot be null");
        }
        this.targets = targets;
    }

    public CFGCall(UnresolvedCall source, Collection<CFG> targets) {
        this(source.getCFG(), source.getLocation(), source.getAssigningStrategy(), source.getCallType(), source.getQualifier(), source.getTargetName(), targets, source.getParameters());
        for (Expression param : source.getParameters()) {
            param.setParentStatement(source);
        }
    }

    private static Type getCommonReturnType(Collection<CFG> targets) {
        Iterator<CFG> it = targets.iterator();
        Type result = null;
        while (it.hasNext()) {
            Type current = it.next().getDescriptor().getReturnType();
            if (result == null) {
                result = current;
            } else {
                if (current.canBeAssignedTo(result)) continue;
                result = result.canBeAssignedTo(current) ? current : result.commonSupertype(current);
            }
            if (!current.isUntyped()) continue;
            break;
        }
        return result == null ? Untyped.INSTANCE : result;
    }

    public Collection<CFG> getTargets() {
        return this.targets;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CFGCall other = (CFGCall)obj;
        return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
    }

    @Override
    public String toString() {
        return "[" + this.targets.size() + " targets] " + super.toString();
    }

    @Override
    public final Identifier getMetaVariable() {
        Variable meta = new Variable(this.getStaticType(), "call_ret_value@" + this.getLocation(), this.getLocation());
        for (CFG target : this.targets) {
            for (Annotation ann : target.getDescriptor().getAnnotations()) {
                meta.addAnnotation(ann);
            }
        }
        return meta;
    }

    @Override
    protected <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> compute(AnalysisState<A, H, V, T> entryState, InterproceduralAnalysis<A, H, V, T> interprocedural, StatementStore<A, H, V, T> expressions, ExpressionSet<SymbolicExpression>[] parameters) throws SemanticException {
        return interprocedural.getAbstractResultOf(this, entryState, parameters, expressions);
    }

    @Override
    public TruncatedParamsCall removeFirstParameter() {
        return new TruncatedParamsCall(new CFGCall(this.getCFG(), this.getLocation(), this.getAssigningStrategy(), this.getCallType(), this.getQualifier(), this.getFullTargetName(), this.getOrder(), this.targets, CanRemoveReceiver.truncate(this.getParameters())));
    }
}

