/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NaryExpression;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.program.cfg.statement.call.assignment.ParameterAssigningStrategy;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class Call
extends NaryExpression {
    private UnresolvedCall source = null;
    private final ParameterAssigningStrategy assigningStrategy;
    private final String qualifier;
    private final String targetName;
    private final CallType callType;

    protected Call(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, CallType type, String qualifier, String targetName, EvaluationOrder order, Type staticType, Expression ... parameters) {
        super(cfg, location, Call.completeName(qualifier, targetName), order, staticType, parameters);
        Objects.requireNonNull(targetName, "The name of the target of a call cannot be null");
        Objects.requireNonNull(assigningStrategy, "The assigning strategy of a call cannot be null");
        this.targetName = targetName;
        this.qualifier = qualifier;
        this.callType = type;
        this.assigningStrategy = assigningStrategy;
    }

    public ParameterAssigningStrategy getAssigningStrategy() {
        return this.assigningStrategy;
    }

    private static String completeName(String qualifier, String name) {
        return StringUtils.isNotBlank((CharSequence)qualifier) ? qualifier + "::" + name : name;
    }

    public final UnresolvedCall getSource() {
        return this.source;
    }

    public String getFullTargetName() {
        return this.getConstructName();
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public final Expression[] getParameters() {
        return this.getSubExpressions();
    }

    public CallType getCallType() {
        return this.callType;
    }

    public void setSource(UnresolvedCall source) {
        this.source = source;
    }

    @Override
    public String toString() {
        return this.getConstructName() + "(" + StringUtils.join((Object[])this.getParameters(), (String)", ") + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.assigningStrategy == null ? 0 : this.assigningStrategy.hashCode());
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        result = 31 * result + (this.targetName == null ? 0 : this.targetName.hashCode());
        result = 31 * result + (this.callType == null ? 0 : this.callType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Call other = (Call)obj;
        if (this.assigningStrategy == null ? other.assigningStrategy != null : !this.assigningStrategy.equals(other.assigningStrategy)) {
            return false;
        }
        if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier)) {
            return false;
        }
        if (this.targetName == null ? other.targetName != null : !this.targetName.equals(other.targetName)) {
            return false;
        }
        return this.callType == other.callType;
    }

    public <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> ExternalSet<Type>[] parameterTypes(StatementStore<A, H, V, T> expressions) {
        Expression[] actuals = this.getParameters();
        ExternalSet[] types = new ExternalSet[actuals.length];
        for (int i = 0; i < actuals.length; ++i) {
            types[i] = ((AnalysisState)expressions.getState(actuals[i])).getDomainInstance(TypeDomain.class).getInferredRuntimeTypes();
        }
        return types;
    }

    public static enum CallType {
        INSTANCE,
        STATIC,
        UNKNOWN;

    }
}

