/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.program.cfg.statement.call.assignment.ParameterAssigningStrategy;
import it.unive.lisa.program.cfg.statement.call.assignment.PythonLikeAssigningStrategy;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.program.cfg.statement.evaluation.LeftToRightEvaluation;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class MultiCall
extends Call {
    private final Collection<Call> calls;

    public MultiCall(CFG cfg, CodeLocation location, Call.CallType callType, String qualifier, String targetName, Collection<Call> calls, Expression ... parameters) {
        this(cfg, location, (ParameterAssigningStrategy)PythonLikeAssigningStrategy.INSTANCE, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, calls, parameters);
    }

    public MultiCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, Call.CallType callType, String qualifier, String targetName, Collection<Call> calls, Expression ... parameters) {
        this(cfg, location, assigningStrategy, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, calls, parameters);
    }

    public MultiCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, Call.CallType callType, String qualifier, String targetName, EvaluationOrder order, Collection<Call> calls, Expression ... parameters) {
        super(cfg, location, assigningStrategy, callType, qualifier, targetName, order, MultiCall.getCommonReturnType(calls), parameters);
        Objects.requireNonNull(calls, "The calls underlying a multi call cannot be null");
        for (Call target : calls) {
            Objects.requireNonNull(target, "A call underlying a multi call cannot be null");
        }
        this.calls = calls;
    }

    private static Type getCommonReturnType(Collection<Call> targets) {
        Iterator<Call> it = targets.iterator();
        Type result = null;
        while (it.hasNext()) {
            Type current = it.next().getStaticType();
            if (result == null) {
                result = current;
            } else {
                if (current.canBeAssignedTo(result)) continue;
                result = result.canBeAssignedTo(current) ? current : result.commonSupertype(current);
            }
            if (!current.isUntyped()) continue;
            break;
        }
        return result == null ? Untyped.INSTANCE : result;
    }

    public MultiCall(UnresolvedCall source, Call ... calls) {
        this(source.getCFG(), source.getLocation(), source.getAssigningStrategy(), source.getCallType(), source.getQualifier(), source.getTargetName(), List.of(calls), source.getParameters());
        for (Expression param : source.getParameters()) {
            param.setParentStatement(source);
        }
    }

    public Collection<Call> getCalls() {
        return this.calls;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.calls == null ? 0 : this.calls.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiCall other = (MultiCall)obj;
        return !(this.calls == null ? other.calls != null : !this.calls.equals(other.calls));
    }

    @Override
    public String toString() {
        return "[multi] " + super.toString();
    }

    @Override
    public void setSource(UnresolvedCall source) {
        super.setSource(source);
        this.calls.forEach(c -> c.setSource(source));
    }

    @Override
    public <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> expressionSemantics(InterproceduralAnalysis<A, H, V, T> interprocedural, AnalysisState<A, H, V, T> state, ExpressionSet<SymbolicExpression>[] params, StatementStore<A, H, V, T> expressions) throws SemanticException {
        AnalysisState<A, H, V, T> result = state.bottom();
        for (Call call : this.calls) {
            result = result.lub(call.expressionSemantics(interprocedural, state, params, expressions));
            this.getMetaVariables().addAll(call.getMetaVariables());
        }
        return result;
    }
}

