/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.NativeCFG;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NaryExpression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.CanRemoveReceiver;
import it.unive.lisa.program.cfg.statement.call.TruncatedParamsCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.program.cfg.statement.call.assignment.ParameterAssigningStrategy;
import it.unive.lisa.program.cfg.statement.call.assignment.PythonLikeAssigningStrategy;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.program.cfg.statement.evaluation.LeftToRightEvaluation;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class NativeCall
extends Call
implements CanRemoveReceiver {
    private final Collection<NativeCFG> targets;

    public NativeCall(CFG cfg, CodeLocation location, Call.CallType callType, String qualifier, String targetName, Collection<NativeCFG> targets, Expression ... parameters) {
        this(cfg, location, (ParameterAssigningStrategy)PythonLikeAssigningStrategy.INSTANCE, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, targets, parameters);
    }

    public NativeCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, Call.CallType callType, String qualifier, String targetName, Collection<NativeCFG> targets, Expression ... parameters) {
        this(cfg, location, assigningStrategy, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, targets, parameters);
    }

    public NativeCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, Call.CallType callType, String qualifier, String targetName, EvaluationOrder order, Collection<NativeCFG> targets, Expression ... parameters) {
        super(cfg, location, assigningStrategy, callType, qualifier, targetName, order, NativeCall.getCommonReturnType(targets), parameters);
        Objects.requireNonNull(targets, "The targets of a native call cannot be null");
        Objects.requireNonNull(targets, "The native targets of a native call cannot be null");
        for (NativeCFG target : targets) {
            Objects.requireNonNull(target, "A native target of a native call cannot be null");
        }
        this.targets = targets;
    }

    public NativeCall(UnresolvedCall source, Collection<NativeCFG> targets) {
        this(source.getCFG(), source.getLocation(), source.getAssigningStrategy(), source.getCallType(), source.getQualifier(), source.getTargetName(), targets, source.getParameters());
        for (Expression param : source.getParameters()) {
            param.setParentStatement(source);
        }
    }

    private static Type getCommonReturnType(Collection<NativeCFG> targets) {
        Iterator<NativeCFG> it = targets.iterator();
        Type result = null;
        while (it.hasNext()) {
            Type current = it.next().getDescriptor().getReturnType();
            if (result == null) {
                result = current;
            } else {
                if (current.canBeAssignedTo(result)) continue;
                result = result.canBeAssignedTo(current) ? current : result.commonSupertype(current);
            }
            if (!current.isUntyped()) continue;
            break;
        }
        return result == null ? Untyped.INSTANCE : result;
    }

    public Collection<NativeCFG> getTargets() {
        return this.targets;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NativeCall other = (NativeCall)obj;
        return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
    }

    @Override
    public String toString() {
        return "[" + this.targets.size() + " targets] " + super.toString();
    }

    @Override
    public <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> expressionSemantics(InterproceduralAnalysis<A, H, V, T> interprocedural, AnalysisState<A, H, V, T> state, ExpressionSet<SymbolicExpression>[] params, StatementStore<A, H, V, T> expressions) throws SemanticException {
        AnalysisState<A, H, V, T> result = state.bottom();
        Expression[] parameters = this.getSubExpressions();
        for (NativeCFG nat : this.targets) {
            try {
                Pair<AnalysisState<A, H, V, T>, ExpressionSet<SymbolicExpression>[]> prepared = this.getAssigningStrategy().prepare(this, state, interprocedural, expressions, nat.getDescriptor().getFormals(), params);
                NaryExpression rewritten = nat.rewrite(this, parameters);
                result = result.lub(rewritten.expressionSemantics(interprocedural, state, (ExpressionSet[])prepared.getRight(), expressions));
                this.getMetaVariables().addAll(rewritten.getMetaVariables());
            }
            catch (CallResolutionException e) {
                throw new SemanticException("Unable to resolve call " + this, e);
            }
        }
        return result;
    }

    @Override
    public TruncatedParamsCall removeFirstParameter() {
        return new TruncatedParamsCall(new NativeCall(this.getCFG(), this.getLocation(), this.getAssigningStrategy(), this.getCallType(), this.getQualifier(), this.getFullTargetName(), this.getOrder(), this.targets, CanRemoveReceiver.truncate(this.getParameters())));
    }
}

