/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.symbolic.SymbolicExpression;

public class TruncatedParamsCall
extends Call {
    private final Call call;

    public TruncatedParamsCall(Call call) {
        super(call.getCFG(), call.getLocation(), call.getAssigningStrategy(), call.getCallType(), call.getQualifier(), call.getTargetName(), call.getOrder(), call.getStaticType(), call.getParameters());
        this.call = call;
    }

    @Override
    public void setSource(UnresolvedCall source) {
        super.setSource(source);
        this.call.setSource(source);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.call == null ? 0 : this.call.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TruncatedParamsCall other = (TruncatedParamsCall)obj;
        return !(this.call == null ? other.call != null : !this.call.equals(other.call));
    }

    @Override
    public <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> expressionSemantics(InterproceduralAnalysis<A, H, V, T> interprocedural, AnalysisState<A, H, V, T> state, ExpressionSet<SymbolicExpression>[] params, StatementStore<A, H, V, T> expressions) throws SemanticException {
        AnalysisState<A, H, V, T> post;
        Expression[] actuals = this.getParameters();
        if (params.length == actuals.length) {
            post = this.call.expressionSemantics(interprocedural, state, params, expressions);
        } else {
            ExpressionSet[] truncatedParams = new ExpressionSet[actuals.length];
            if (actuals.length > 0) {
                System.arraycopy(params, 1, truncatedParams, 0, params.length - 1);
            }
            post = this.call.expressionSemantics(interprocedural, state, truncatedParams, expressions);
        }
        this.getMetaVariables().addAll(this.call.getMetaVariables());
        return post;
    }
}

