/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.assignment.ParameterAssigningStrategy;
import it.unive.lisa.program.cfg.statement.call.assignment.PythonLikeAssigningStrategy;
import it.unive.lisa.program.cfg.statement.call.resolution.ParameterMatchingStrategy;
import it.unive.lisa.program.cfg.statement.call.traversal.HierarcyTraversalStrategy;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.program.cfg.statement.evaluation.LeftToRightEvaluation;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Objects;

public class UnresolvedCall
extends Call {
    private final ParameterMatchingStrategy matchingStrategy;
    private final HierarcyTraversalStrategy traversalStrategy;

    public UnresolvedCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, ParameterMatchingStrategy matchingStrategy, HierarcyTraversalStrategy traversalStrategy, Call.CallType callType, String qualifier, String targetName, Expression ... parameters) {
        this(cfg, location, assigningStrategy, matchingStrategy, traversalStrategy, callType, qualifier, targetName, Untyped.INSTANCE, parameters);
    }

    public UnresolvedCall(CFG cfg, CodeLocation location, ParameterMatchingStrategy matchingStrategy, HierarcyTraversalStrategy traversalStrategy, Call.CallType callType, String qualifier, String targetName, Expression ... parameters) {
        this(cfg, location, (ParameterAssigningStrategy)PythonLikeAssigningStrategy.INSTANCE, matchingStrategy, traversalStrategy, callType, qualifier, targetName, Untyped.INSTANCE, parameters);
    }

    public UnresolvedCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, ParameterMatchingStrategy matchingStrategy, HierarcyTraversalStrategy traversalStrategy, Call.CallType callType, String qualifier, String targetName, Type staticType, Expression ... parameters) {
        this(cfg, location, assigningStrategy, matchingStrategy, traversalStrategy, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, staticType, parameters);
    }

    public UnresolvedCall(CFG cfg, CodeLocation location, ParameterMatchingStrategy matchingStrategy, HierarcyTraversalStrategy traversalStrategy, Call.CallType callType, String qualifier, String targetName, Type staticType, Expression ... parameters) {
        this(cfg, location, (ParameterAssigningStrategy)PythonLikeAssigningStrategy.INSTANCE, matchingStrategy, traversalStrategy, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, staticType, parameters);
    }

    public UnresolvedCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, ParameterMatchingStrategy matchingStrategy, HierarcyTraversalStrategy traversalStrategy, Call.CallType callType, String qualifier, String targetName, EvaluationOrder order, Expression ... parameters) {
        this(cfg, location, assigningStrategy, matchingStrategy, traversalStrategy, callType, qualifier, targetName, order, Untyped.INSTANCE, parameters);
    }

    public UnresolvedCall(CFG cfg, CodeLocation location, ParameterMatchingStrategy matchingStrategy, HierarcyTraversalStrategy traversalStrategy, Call.CallType callType, String qualifier, String targetName, EvaluationOrder order, Expression ... parameters) {
        this(cfg, location, (ParameterAssigningStrategy)PythonLikeAssigningStrategy.INSTANCE, matchingStrategy, traversalStrategy, callType, qualifier, targetName, order, Untyped.INSTANCE, parameters);
    }

    public UnresolvedCall(CFG cfg, CodeLocation location, ParameterAssigningStrategy assigningStrategy, ParameterMatchingStrategy matchingStrategy, HierarcyTraversalStrategy traversalStrategy, Call.CallType callType, String qualifier, String targetName, EvaluationOrder order, Type staticType, Expression ... parameters) {
        super(cfg, location, assigningStrategy, callType, qualifier, targetName, order, staticType, parameters);
        Objects.requireNonNull(matchingStrategy, "The matching strategy of an unresolved call cannot be null");
        Objects.requireNonNull(traversalStrategy, "The traversal strategy of an unresolved call cannot be null");
        this.matchingStrategy = matchingStrategy;
        this.traversalStrategy = traversalStrategy;
    }

    public ParameterMatchingStrategy getMatchingStrategy() {
        return this.matchingStrategy;
    }

    public HierarcyTraversalStrategy getTraversalStrategy() {
        return this.traversalStrategy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.matchingStrategy == null ? 0 : this.matchingStrategy.hashCode());
        result = 31 * result + (this.traversalStrategy == null ? 0 : this.traversalStrategy.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof UnresolvedCall)) {
            return false;
        }
        UnresolvedCall other = (UnresolvedCall)obj;
        if (this.matchingStrategy == null ? other.matchingStrategy != null : !this.matchingStrategy.equals(other.matchingStrategy)) {
            return false;
        }
        return !(this.traversalStrategy == null ? other.traversalStrategy != null : !this.traversalStrategy.equals(other.traversalStrategy));
    }

    @Override
    public <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> expressionSemantics(InterproceduralAnalysis<A, H, V, T> interprocedural, AnalysisState<A, H, V, T> state, ExpressionSet<SymbolicExpression>[] params, StatementStore<A, H, V, T> expressions) throws SemanticException {
        Call resolved;
        try {
            resolved = interprocedural.resolve(this, this.parameterTypes(expressions), state.getAliasing());
        }
        catch (CallResolutionException e) {
            throw new SemanticException("Unable to resolve call " + this, e);
        }
        AnalysisState<A, H, V, T> result = resolved.expressionSemantics(interprocedural, state, params, expressions);
        this.getMetaVariables().addAll(resolved.getMetaVariables());
        return result;
    }
}

