/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call.resolution;

import it.unive.lisa.caches.Caches;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.NamedParameterExpression;
import it.unive.lisa.program.cfg.statement.call.resolution.FixedOrderMatchingStrategy;
import it.unive.lisa.program.cfg.statement.call.resolution.ParameterMatchingStrategy;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public class PythonLikeMatchingStrategy
implements ParameterMatchingStrategy {
    private final FixedOrderMatchingStrategy delegate;

    public PythonLikeMatchingStrategy(FixedOrderMatchingStrategy delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean matches(Call call, Parameter[] formals, Expression[] actuals, ExternalSet<Type>[] types) {
        Expression[] slots = new Expression[formals.length];
        ExternalSet[] slotTypes = new ExternalSet[formals.length];
        Expression[] defaults = new Expression[formals.length];
        ExternalSet[] defaultTypes = new ExternalSet[formals.length];
        for (int pos = 0; pos < slots.length; ++pos) {
            Expression def = formals[pos].getDefaultValue();
            if (def == null) continue;
            defaults[pos] = def;
            defaultTypes[pos] = Caches.types().mkSet(def.getStaticType().allInstances());
        }
        Boolean logic = PythonLikeMatchingStrategy.pythonLogic(formals, actuals, actuals, types, defaults, defaultTypes, slots, slotTypes, false);
        if (logic != null) {
            return logic;
        }
        return this.delegate.matches(call, formals, slots, slotTypes);
    }

    public static <T, F> F pythonLogic(Parameter[] formals, Expression[] actuals, T[] given, ExternalSet<Type>[] givenTypes, T[] defaults, ExternalSet<Type>[] defaultTypes, T[] slots, ExternalSet<Type>[] slotTypes, F failure) {
        int pos;
        if (formals.length < actuals.length) {
            return failure;
        }
        for (pos = 0; pos < actuals.length && !(actuals[pos] instanceof NamedParameterExpression); ++pos) {
            slots[pos] = given[pos];
            slotTypes[pos] = givenTypes[pos];
        }
        while (pos < actuals.length) {
            String name = ((NamedParameterExpression)actuals[pos]).getParameterName();
            for (int i = pos; i < formals.length; ++i) {
                if (!formals[i].getName().equals(name)) continue;
                if (slots[i] != null) {
                    return failure;
                }
                slots[i] = given[pos];
                slotTypes[i] = givenTypes[pos];
                break;
            }
            ++pos;
        }
        for (pos = 0; pos < slots.length; ++pos) {
            if (slots[pos] != null) continue;
            if (defaults[pos] == null) {
                return failure;
            }
            slots[pos] = defaults[pos];
            slotTypes[pos] = defaultTypes[pos];
        }
        return null;
    }
}

