/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call.traversal;

import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.traversal.HierarcyTraversalStrategy;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

public class SingleInheritanceTraversalStrategy
implements HierarcyTraversalStrategy {
    public static final SingleInheritanceTraversalStrategy INSTANCE = new SingleInheritanceTraversalStrategy();

    private SingleInheritanceTraversalStrategy() {
    }

    @Override
    public Iterable<CompilationUnit> traverse(Call call, final CompilationUnit start) {
        return new Iterable<CompilationUnit>(){

            @Override
            public Iterator<CompilationUnit> iterator() {
                return new SingleInheritanceIterator(start);
            }
        };
    }

    private class SingleInheritanceIterator
    implements Iterator<CompilationUnit> {
        private CompilationUnit current;
        private final Deque<CompilationUnit> remaining;
        private final Set<CompilationUnit> seen;

        private SingleInheritanceIterator(CompilationUnit start) {
            this.current = start;
            this.remaining = new LinkedList<CompilationUnit>(start.getSuperUnits());
            this.remaining.addFirst(start);
            this.seen = new HashSet<CompilationUnit>(this.remaining);
        }

        @Override
        public boolean hasNext() {
            return !this.remaining.isEmpty();
        }

        @Override
        public CompilationUnit next() {
            if (this.remaining.isEmpty()) {
                throw new NoSuchElementException();
            }
            CompilationUnit cu = this.remaining.pop();
            if (this.remaining.isEmpty()) {
                if (this.current.getSuperUnits().isEmpty()) {
                    this.current = null;
                } else {
                    this.current = this.current.getSuperUnits().iterator().next();
                    this.current.getSuperUnits().forEach(su -> {
                        if (this.seen.add((CompilationUnit)su)) {
                            this.remaining.add((CompilationUnit)su);
                        }
                    });
                    this.remaining.addFirst(this.current);
                }
            }
            return cu;
        }
    }
}

