/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.global;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.UnaryExpression;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public class AccessInstanceGlobal
extends UnaryExpression {
    private final Global target;

    public AccessInstanceGlobal(CFG cfg, CodeLocation location, Expression receiver, Global target) {
        super(cfg, location, "::", target.getStaticType(), receiver);
        this.target = target;
        receiver.setParentStatement(this);
    }

    public Expression getReceiver() {
        return this.getSubExpression();
    }

    public Global getTarget() {
        return this.target;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessInstanceGlobal other = (AccessInstanceGlobal)obj;
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    @Override
    public String toString() {
        return this.getSubExpression() + "::" + this.target.getName();
    }

    @Override
    protected <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> unarySemantics(InterproceduralAnalysis<A, H, V, T> interprocedural, AnalysisState<A, H, V, T> state, SymbolicExpression expr, StatementStore<A, H, V, T> expressions) throws SemanticException {
        Variable var = new Variable(this.target.getStaticType(), this.target.getName(), this.target.getAnnotations(), this.target.getLocation());
        ExternalSet<Type> rectypes = Caches.types().mkEmptySet();
        for (Type t2 : expr.getRuntimeTypes()) {
            if (!t2.isPointerType()) continue;
            rectypes.addAll(t2.asPointerType().getInnerTypes());
        }
        if (rectypes.isEmpty()) {
            return state.bottom();
        }
        Type rectype = rectypes.reduce(rectypes.first(), (r, t) -> r.commonSupertype((Type)t));
        HeapDereference container = new HeapDereference(rectype, expr, this.getLocation());
        container.setRuntimeTypes(rectypes);
        AccessChild access = new AccessChild(var.getStaticType(), container, var, this.getLocation());
        return state.smallStepSemantics(access, (ProgramPoint)this);
    }
}

