/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.Objects;

public abstract class SymbolicExpression {
    private final CodeLocation location;
    private final Type staticType;
    private ExternalSet<Type> types;

    protected SymbolicExpression(Type staticType, CodeLocation location) {
        Objects.requireNonNull(staticType, "The static type of a symbolic expression cannot be null");
        Objects.requireNonNull(location, "The location of a symbolic expression cannot be null");
        this.staticType = staticType;
        this.location = location;
    }

    public Type getStaticType() {
        return this.staticType;
    }

    public final ExternalSet<Type> getRuntimeTypes() {
        if (this.types == null) {
            return Caches.types().mkSet(this.staticType.allInstances());
        }
        return this.types;
    }

    public void setRuntimeTypes(ExternalSet<Type> types) {
        this.types = types;
    }

    public boolean hasRuntimeTypes() {
        return this.types != null;
    }

    public final Type getDynamicType() {
        if (this.types == null || this.types.isEmpty()) {
            return this.staticType;
        }
        return this.types.reduce(this.types.first(), (result, t) -> result.commonSupertype((Type)t));
    }

    public abstract SymbolicExpression pushScope(ScopeToken var1) throws SemanticException;

    public abstract SymbolicExpression popScope(ScopeToken var1) throws SemanticException;

    public abstract <T> T accept(ExpressionVisitor<T> var1, Object ... var2) throws SemanticException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.staticType == null ? 0 : this.staticType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolicExpression other = (SymbolicExpression)obj;
        return !(this.staticType == null ? other.staticType != null : !this.staticType.equals(other.staticType));
    }

    public CodeLocation getCodeLocation() {
        return this.location;
    }

    public abstract String toString();
}

