/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.heap;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.type.Type;

public class HeapDereference
extends HeapExpression {
    private final SymbolicExpression toDeref;

    public HeapDereference(Type staticType, SymbolicExpression toDeref, CodeLocation location) {
        super(staticType, location);
        this.toDeref = toDeref;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.toDeref == null ? 0 : this.toDeref.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeapDereference other = (HeapDereference)obj;
        return !(this.toDeref == null ? other.toDeref != null : !this.toDeref.equals(other.toDeref));
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        T deref = this.toDeref.accept(visitor, params);
        return visitor.visit(this, deref, params);
    }

    public SymbolicExpression getExpression() {
        return this.toDeref;
    }

    @Override
    public String toString() {
        return "*(" + this.toDeref + ")";
    }
}

