/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.heap;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.type.Type;

public class HeapReference
extends HeapExpression {
    private final SymbolicExpression expression;

    public HeapReference(Type staticType, SymbolicExpression expression, CodeLocation location) {
        super(staticType, location);
        this.expression = expression;
    }

    @Override
    public String toString() {
        return "ref$" + this.expression.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    public SymbolicExpression getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeapReference other = (HeapReference)obj;
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        T l = this.expression.accept(visitor, params);
        return visitor.visit(this, l, params);
    }
}

