/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value.operator.binary;

import it.unive.lisa.caches.Caches;
import it.unive.lisa.symbolic.value.operator.OverflowingOperator;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.type.NumericType;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.function.Predicate;

public class Numeric16BitSub
implements SubtractionOperator,
OverflowingOperator,
BinaryOperator {
    public static final Numeric16BitSub INSTANCE = new Numeric16BitSub();

    private Numeric16BitSub() {
    }

    public String toString() {
        return "-";
    }

    @Override
    public ExternalSet<Type> typeInference(ExternalSet<Type> left, ExternalSet<Type> right) {
        Predicate<Type> test = type -> type.isNumericType() && type.asNumericType().is16Bits();
        if (left.noneMatch(test) || right.noneMatch(test)) {
            return Caches.types().mkEmptySet();
        }
        ExternalSet<Type> set = NumericType.commonNumericalType(left, right).filter(test);
        if (set.isEmpty()) {
            return Caches.types().mkEmptySet();
        }
        return set;
    }
}

