/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.type;

import it.unive.lisa.caches.Caches;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public interface NumericType
extends Type {
    public boolean is8Bits();

    public boolean is16Bits();

    public boolean is32Bits();

    public boolean is64Bits();

    public boolean isUnsigned();

    public boolean isIntegral();

    default public boolean isSigned() {
        return !this.isUnsigned();
    }

    public static boolean sameNumericTypes(NumericType t1, NumericType t2) {
        if (t1.is8Bits() != t2.is8Bits()) {
            return false;
        }
        if (t1.is16Bits() != t2.is16Bits()) {
            return false;
        }
        if (t1.is32Bits() != t2.is32Bits()) {
            return false;
        }
        if (t1.is64Bits() != t2.is64Bits()) {
            return false;
        }
        if (t1.isIntegral() != t2.isIntegral()) {
            return false;
        }
        return t1.isUnsigned() == t2.isUnsigned();
    }

    public static NumericType supertype(NumericType t1, NumericType t2) {
        if (t1.is8Bits() && (t2.is16Bits() || t2.is32Bits() || t2.is64Bits())) {
            return t2;
        }
        if (t2.is8Bits() && (t1.is16Bits() || t1.is32Bits() || t1.is64Bits())) {
            return t1;
        }
        if (t1.is16Bits() && (t2.is32Bits() || t2.is64Bits())) {
            return t2;
        }
        if (t2.is16Bits() && (t1.is32Bits() || t1.is64Bits())) {
            return t1;
        }
        if (t1.is32Bits() && t2.is64Bits()) {
            return t2;
        }
        if (t2.is32Bits() && t1.is64Bits()) {
            return t1;
        }
        if (t1.isIntegral() && !t2.isIntegral()) {
            return t2;
        }
        if (!t1.isIntegral() && t2.isIntegral()) {
            return t1;
        }
        if (t1.isUnsigned() && t2.isSigned()) {
            return t2;
        }
        if (t1.isSigned() && t2.isUnsigned()) {
            return t1;
        }
        return t1;
    }

    public static ExternalSet<Type> commonNumericalType(ExternalSet<Type> left, ExternalSet<Type> right) {
        if (left.noneMatch(Type::isNumericType) && right.noneMatch(Type::isNumericType)) {
            return Caches.types().mkEmptySet();
        }
        ExternalSet<Type> result = Caches.types().mkEmptySet();
        for (Type t1 : left.filter(type -> type.isNumericType() || type.isUntyped())) {
            for (Type t2 : right.filter(type -> type.isNumericType() || type.isUntyped())) {
                if (t1.isUntyped() && t2.isUntyped()) {
                    result.add(t1);
                    continue;
                }
                if (t1.isUntyped()) {
                    result.add(t2);
                    continue;
                }
                if (t2.isUntyped()) {
                    result.add(t1);
                    continue;
                }
                result.add(t1.commonSupertype(t2));
            }
        }
        return result;
    }
}

