/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.type.common;

import it.unive.lisa.type.NumericType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.Collections;

public class Int32
implements NumericType {
    public static final Int32 INSTANCE = new Int32();

    private Int32() {
    }

    @Override
    public boolean is8Bits() {
        return false;
    }

    @Override
    public boolean is16Bits() {
        return false;
    }

    @Override
    public boolean is32Bits() {
        return true;
    }

    @Override
    public boolean is64Bits() {
        return false;
    }

    @Override
    public boolean isUnsigned() {
        return false;
    }

    @Override
    public boolean isIntegral() {
        return true;
    }

    @Override
    public boolean canBeAssignedTo(Type other) {
        return other.isNumericType() || other.isUntyped();
    }

    @Override
    public Type commonSupertype(Type other) {
        if (!other.isNumericType()) {
            return Untyped.INSTANCE;
        }
        return NumericType.supertype(this, other.asNumericType());
    }

    public String toString() {
        return "int32";
    }

    public final boolean equals(Object other) {
        if (!(other instanceof NumericType)) {
            return false;
        }
        return NumericType.sameNumericTypes(this, (NumericType)other);
    }

    public final int hashCode() {
        return Int32.class.getName().hashCode();
    }

    @Override
    public Collection<Type> allInstances() {
        return Collections.singleton(this);
    }
}

