/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;

public final class CollectionUtilities {
    private CollectionUtilities() {
    }

    public static <T> int nullSafeCompare(boolean nullFirst, T left, T right, Comparator<T> comparator) {
        if (left == null && right != null) {
            return nullFirst ? -1 : 1;
        }
        if (left != null && right == null) {
            return nullFirst ? 1 : -1;
        }
        if (left == null) {
            return 0;
        }
        return comparator.compare(left, right);
    }

    public static <T, C extends Collection<T>> boolean equals(C first, C second, BiPredicate<T, T> equalityTest) {
        HashSet copy = new HashSet(second);
        for (T t1 : first) {
            boolean found = false;
            for (T t2 : second) {
                if (!copy.contains(t2) || !equalityTest.test(t1, t2)) continue;
                copy.remove(t2);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return copy.isEmpty();
    }

    public static <T, C extends Collection<T>> void join(C first, C second, C result, BiPredicate<T, T> equalityTest, BinaryOperator<T> joiner) {
        HashSet copy = new HashSet(second);
        for (T t1 : first) {
            boolean found = false;
            for (T t2 : second) {
                if (!copy.contains(t2) || !equalityTest.test(t1, t2)) continue;
                copy.remove(t2);
                found = true;
                result.add(joiner.apply(t1, t2));
                break;
            }
            if (found) continue;
            result.add(t1);
        }
        copy.forEach(result::add);
    }

    @SafeVarargs
    public static <T> Collection<T> collect(T ... objs) {
        ArrayList<T> res = new ArrayList<T>(objs.length);
        for (T o : objs) {
            res.add(o);
        }
        return res;
    }
}

