/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CollectionsDiffBuilder<T> {
    private final Class<T> elementType;
    private final Collection<T> first;
    private final Collection<T> second;
    private final List<T> onlyFirst = new ArrayList<T>();
    private final List<Pair<T, T>> commons = new ArrayList<Pair<T, T>>();
    private final List<T> onlySecond = new ArrayList<T>();

    public CollectionsDiffBuilder(Class<T> elementType, Collection<T> first, Collection<T> second) {
        this.elementType = elementType;
        this.first = first;
        this.second = second;
    }

    public void compute(Comparator<T> comparer) {
        this.commons.clear();
        this.onlyFirst.clear();
        this.onlySecond.clear();
        ArrayDeque<Object> f = new ArrayDeque<Object>();
        ArrayDeque<Object> s = new ArrayDeque<Object>();
        Object[] fArray = this.first.toArray((Object[])Array.newInstance(this.elementType, this.first.size()));
        Object[] sArray = this.second.toArray((Object[])Array.newInstance(this.elementType, this.second.size()));
        Arrays.sort(fArray, comparer);
        Arrays.sort(sArray, comparer);
        f.addAll(Arrays.asList(fArray));
        s.addAll(Arrays.asList(sArray));
        this.queueDiff(f, s, comparer);
    }

    private void queueDiff(Deque<T> f, Deque<T> s, Comparator<T> comparer) {
        Object currentF = null;
        Object currentS = null;
        while (!f.isEmpty() || !s.isEmpty()) {
            currentF = f.peek();
            currentS = s.peek();
            if (currentF == null) {
                if (currentS == null) break;
                this.onlySecond.add(currentS);
                s.remove();
                continue;
            }
            if (currentS == null) {
                this.onlyFirst.add(currentF);
                f.remove();
                continue;
            }
            int cmp = comparer.compare(currentF, currentS);
            if (cmp == 0) {
                this.commons.add((Pair<T, T>)new ImmutablePair(currentF, currentS));
                f.remove();
                s.remove();
                continue;
            }
            if (cmp < 0) {
                this.onlyFirst.add(currentF);
                f.remove();
                continue;
            }
            this.onlySecond.add(currentS);
            s.remove();
        }
    }

    public Collection<T> getOnlySecond() {
        return this.onlySecond;
    }

    public Collection<T> getOnlyFirst() {
        return this.onlyFirst;
    }

    public Collection<Pair<T, T>> getCommons() {
        return this.commons;
    }

    public boolean sameContent() {
        return this.onlyFirst.isEmpty() && this.onlySecond.isEmpty();
    }
}

