/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections.workset;

import it.unive.lisa.util.collections.workset.WorkingSet;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;

public final class VisitOnceWorkingSet<E>
implements WorkingSet<E> {
    private final WorkingSet<E> ws;
    private final Collection<E> seen;

    private VisitOnceWorkingSet(WorkingSet<E> ws) {
        this.ws = ws;
        this.seen = Collections.newSetFromMap(new IdentityHashMap());
    }

    public static <E> VisitOnceWorkingSet<E> mk(WorkingSet<E> ws) {
        return new VisitOnceWorkingSet<E>(ws);
    }

    @Override
    public void push(E e) {
        if (this.seen.contains(e)) {
            return;
        }
        this.seen.add(e);
        this.ws.push(e);
    }

    @Override
    public E pop() {
        return this.ws.pop();
    }

    @Override
    public E peek() {
        return this.ws.peek();
    }

    @Override
    public int size() {
        return this.ws.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ws.isEmpty();
    }

    public String toString() {
        return this.ws.toString();
    }

    public Collection<E> getSeen() {
        return this.seen;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.seen == null ? 0 : this.seen.hashCode());
        result = 31 * result + (this.ws == null ? 0 : this.ws.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VisitOnceWorkingSet other = (VisitOnceWorkingSet)obj;
        if (this.seen == null ? other.seen != null : !this.seen.equals(other.seen)) {
            return false;
        }
        return !(this.ws == null ? other.ws != null : !this.ws.equals(other.ws));
    }
}

