/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph;

import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AdjacencyMatrix<N extends Node<N, E, G>, E extends Edge<N, E, G>, G extends Graph<G, N, E>>
implements Iterable<Map.Entry<N, NodeEdges<N, E, G>>> {
    private static final String EDGE_SIMPLIFY_ERROR = "Cannot simplify an edge with class ";
    private final Map<N, NodeEdges<N, E, G>> matrix = new ConcurrentHashMap<N, NodeEdges<N, E, G>>();
    private int nextOffset;

    public AdjacencyMatrix() {
        this.nextOffset = 0;
    }

    public AdjacencyMatrix(AdjacencyMatrix<N, E, G> other) {
        for (Map.Entry<N, NodeEdges<N, E, G>> entry : other.matrix.entrySet()) {
            this.matrix.put((Node)entry.getKey(), new NodeEdges<N, E, G>(entry.getValue()));
        }
        this.nextOffset = other.nextOffset;
    }

    public void addNode(N node) {
        if (this.matrix.putIfAbsent(node, new NodeEdges()) == null) {
            this.nextOffset = node.setOffset(this.nextOffset) + 1;
        }
    }

    public void removeNode(N node) {
        if (!this.containsNode(node)) {
            return;
        }
        NodeEdges<N, E, G> edges = this.matrix.get(node);
        HashSet union = new HashSet(edges.ingoing);
        union.addAll(edges.outgoing);
        union.forEach(this::removeEdge);
        this.matrix.remove(node);
    }

    public final Collection<N> getNodes() {
        return this.matrix.keySet();
    }

    public void addEdge(E e) {
        if (!this.matrix.containsKey(e.getSource())) {
            throw new UnsupportedOperationException("The source node is not in the graph");
        }
        if (!this.matrix.containsKey(e.getDestination())) {
            throw new UnsupportedOperationException("The destination node is not in the graph");
        }
        this.matrix.get(e.getSource()).outgoing.add(e);
        this.matrix.get(e.getDestination()).ingoing.add(e);
    }

    public void removeEdge(E e) {
        if (!this.matrix.containsKey(e.getSource()) || !this.matrix.containsKey(e.getDestination())) {
            return;
        }
        this.matrix.get(e.getSource()).outgoing.remove(e);
        this.matrix.get(e.getDestination()).ingoing.remove(e);
    }

    public final E getEdgeConnecting(N source, N destination) {
        if (!this.matrix.containsKey(source)) {
            return null;
        }
        for (Edge e : this.matrix.get(source).outgoing) {
            if (!e.getDestination().equals(destination)) continue;
            return (E)e;
        }
        return null;
    }

    public final Collection<E> getIngoingEdges(N node) {
        return this.matrix.get(node).ingoing;
    }

    public final Collection<E> getOutgoingEdges(N node) {
        return this.matrix.get(node).outgoing;
    }

    public final Collection<E> getEdges() {
        return this.matrix.values().stream().flatMap(c -> Stream.concat(c.ingoing.stream(), c.outgoing.stream())).distinct().collect(Collectors.toSet());
    }

    public final Collection<N> followersOf(N node) {
        if (!this.matrix.containsKey(node)) {
            throw new IllegalArgumentException("'" + node + "' is not in the graph");
        }
        return this.matrix.get(node).outgoing.stream().map(Edge::getDestination).collect(Collectors.toSet());
    }

    public final Collection<N> predecessorsOf(N node) {
        if (!this.matrix.containsKey(node)) {
            throw new IllegalArgumentException("'" + node + "' is not in the graph");
        }
        return this.matrix.get(node).ingoing.stream().map(Edge::getSource).collect(Collectors.toSet());
    }

    public void simplify(Iterable<N> targets, Collection<N> entrypoints, Collection<E> removedEdges, Map<Pair<E, E>, E> replacedEdges) {
        removedEdges.clear();
        replacedEdges.clear();
        for (Node t : targets) {
            HashSet ingoing = new HashSet(this.matrix.get((Object)t).ingoing);
            HashSet outgoing = new HashSet(this.matrix.get((Object)t).outgoing);
            boolean entry = entrypoints.contains(t);
            if (ingoing.isEmpty() && !outgoing.isEmpty()) {
                for (Edge out : outgoing) {
                    if (!out.canBeSimplified()) {
                        throw new UnsupportedOperationException(EDGE_SIMPLIFY_ERROR + out.getClass().getSimpleName());
                    }
                    removedEdges.add(out);
                    this.matrix.get(out.getDestination()).ingoing.remove(out);
                    if (!entry) continue;
                    entrypoints.add(out.getDestination());
                }
            } else if (!ingoing.isEmpty() && outgoing.isEmpty()) {
                for (Edge in : ingoing) {
                    if (!in.canBeSimplified()) {
                        throw new UnsupportedOperationException(EDGE_SIMPLIFY_ERROR + in.getClass().getSimpleName());
                    }
                    removedEdges.add(in);
                    this.matrix.get(in.getSource()).outgoing.remove(in);
                }
            } else {
                for (Edge in : ingoing) {
                    for (Edge out : outgoing) {
                        if (!out.canBeSimplified()) {
                            throw new UnsupportedOperationException(EDGE_SIMPLIFY_ERROR + out.getClass().getSimpleName());
                        }
                        Object _new = in.newInstance(in.getSource(), out.getDestination());
                        replacedEdges.put(Pair.of((Object)in, (Object)out), _new);
                        this.matrix.get(in.getSource()).outgoing.remove(in);
                        this.matrix.get(in.getSource()).outgoing.add(_new);
                        this.matrix.get(out.getDestination()).ingoing.remove(out);
                        this.matrix.get(out.getDestination()).ingoing.add(_new);
                    }
                }
            }
            if (entry) {
                entrypoints.remove(t);
            }
            this.matrix.remove(t);
        }
    }

    public boolean containsNode(N node) {
        return this.matrix.containsKey(node);
    }

    public boolean containsEdge(E edge) {
        for (NodeEdges<N, E, G> edges : this.matrix.values()) {
            for (Edge e : edges.outgoing) {
                if (e != edge && !e.equals(edge)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<Map.Entry<N, NodeEdges<N, E, G>>> iterator() {
        return this.matrix.entrySet().iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.matrix == null ? 0 : this.matrix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdjacencyMatrix other = (AdjacencyMatrix)obj;
        return !(this.matrix == null ? other.matrix != null : !this.matrix.equals(other.matrix));
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (Map.Entry<N, NodeEdges<N, E, G>> entry : this) {
            res.append("\"").append(entry.getKey()).append("\" -> [\n\tingoing: ");
            res.append(StringUtils.join(entry.getValue().ingoing, (String)", "));
            res.append("\n\toutgoing: ");
            res.append(StringUtils.join(entry.getValue().outgoing, (String)", "));
            res.append("\n]\n");
        }
        return res.toString();
    }

    public void removeFrom(N root) {
        if (!this.containsNode(root)) {
            return;
        }
        HashSet<Object> add = new HashSet<Object>();
        HashSet<Object> remove = new HashSet<Object>();
        HashSet check = new HashSet();
        if (this.containsNode(root)) {
            add.add(root);
        } else {
            for (Node node : this.matrix.keySet()) {
                if (!node.equals(root)) continue;
                add.add(node);
            }
        }
        do {
            remove.addAll(add);
            check.clear();
            for (Node node : add) {
                this.matrix.get((Object)node).outgoing.stream().map(Edge::getDestination).forEach(check::add);
            }
            add.clear();
            check.stream().filter(n -> !remove.contains(n)).forEach(add::add);
        } while (!add.isEmpty());
        this.simplify(remove, Collections.emptyList(), new LinkedList(), new HashMap());
    }

    public Collection<N> getEntries() {
        return this.matrix.entrySet().stream().filter(e -> ((NodeEdges)e.getValue()).ingoing.isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Collection<N> getExits() {
        return this.matrix.entrySet().stream().filter(e -> ((NodeEdges)e.getValue()).outgoing.isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public int distance(N from, N to) {
        if (!this.containsNode(from) || !this.containsNode(to)) {
            return -1;
        }
        IdentityHashMap<Object, Integer> distances = new IdentityHashMap<Object, Integer>(this.matrix.size());
        LinkedList<Object> queue = new LinkedList<Object>();
        distances.put(from, 0);
        queue.add(from);
        while (!queue.isEmpty()) {
            Node x = (Node)queue.peek();
            queue.poll();
            for (Node follower : this.followersOf(x)) {
                if (distances.containsKey(follower)) continue;
                distances.put(follower, (Integer)distances.get(x) + 1);
                queue.add(follower);
            }
        }
        return distances.getOrDefault(to, -1);
    }

    public void mergeWith(AdjacencyMatrix<N, E, G> other) {
        for (Node node : other.getNodes()) {
            this.addNode(node);
        }
        for (Edge edge : other.getEdges()) {
            this.addEdge(edge);
        }
    }

    public void validate(Collection<N> entrypoints) throws ProgramValidationException {
        Collection<N> nodes = this.getNodes();
        for (Map.Entry<N, NodeEdges<N, E, G>> st : this.matrix.entrySet()) {
            for (Edge in : st.getValue().ingoing) {
                this.validateEdge(nodes, in);
            }
            for (Edge out : st.getValue().outgoing) {
                this.validateEdge(nodes, out);
            }
            if (!st.getValue().ingoing.isEmpty() || entrypoints.contains(st.getKey())) continue;
            throw new ProgramValidationException("Unreachable node that is not marked as entrypoint: " + st.getKey());
        }
    }

    private void validateEdge(Collection<N> nodes, E edge) throws ProgramValidationException {
        if (!nodes.contains(edge.getSource())) {
            throw new ProgramValidationException("Invalid edge: '" + edge + "' originates in a node that is not part of the graph");
        }
        if (!nodes.contains(edge.getDestination())) {
            throw new ProgramValidationException("Invalid edge: '" + edge + "' reaches a node that is not part of the graph");
        }
    }

    public static class NodeEdges<N extends Node<N, E, G>, E extends Edge<N, E, G>, G extends Graph<G, N, E>> {
        private final Set<E> ingoing;
        private final Set<E> outgoing;

        private NodeEdges() {
            this.ingoing = new HashSet();
            this.outgoing = new HashSet();
        }

        private NodeEdges(NodeEdges<N, E, G> other) {
            this.ingoing = new HashSet<E>(other.ingoing);
            this.outgoing = new HashSet<E>(other.outgoing);
        }

        public Set<E> getIngoing() {
            return this.ingoing;
        }

        public Set<E> getOutgoing() {
            return this.outgoing;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ingoing == null ? 0 : this.ingoing.hashCode());
            result = 31 * result + (this.outgoing == null ? 0 : this.outgoing.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeEdges other = (NodeEdges)obj;
            if (this.ingoing == null ? other.ingoing != null : !this.ingoing.equals(other.ingoing)) {
                return false;
            }
            return !(this.outgoing == null ? other.outgoing != null : !this.outgoing.equals(other.outgoing));
        }

        public String toString() {
            return "ins: " + this.ingoing + ", outs: " + this.outgoing;
        }
    }
}

