/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph;

import it.unive.lisa.outputs.DotGraph;
import it.unive.lisa.util.datastructures.graph.AdjacencyMatrix;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import it.unive.lisa.util.datastructures.graph.Node;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Graph<G extends Graph<G, N, E>, N extends Node<N, E, G>, E extends Edge<N, E, G>> {
    protected final AdjacencyMatrix<N, E, G> adjacencyMatrix;
    protected final Collection<N> entrypoints;

    protected Graph() {
        this.adjacencyMatrix = new AdjacencyMatrix();
        this.entrypoints = new HashSet<N>();
    }

    protected Graph(Collection<N> entrypoints, AdjacencyMatrix<N, E, G> adjacencyMatrix) {
        this.adjacencyMatrix = adjacencyMatrix;
        this.entrypoints = entrypoints;
    }

    protected Graph(G other) {
        this.adjacencyMatrix = new AdjacencyMatrix<N, E, G>(((Graph)other).adjacencyMatrix);
        this.entrypoints = new ArrayList<N>(((Graph)other).entrypoints);
    }

    public AdjacencyMatrix<N, E, G> getAdjacencyMatrix() {
        return this.adjacencyMatrix;
    }

    public final Collection<N> getEntrypoints() {
        return this.entrypoints;
    }

    public final Collection<N> getNodes() {
        return this.adjacencyMatrix.getNodes();
    }

    public final Collection<E> getEdges() {
        return this.adjacencyMatrix.getEdges();
    }

    public final void addNode(N node) {
        this.addNode(node, false);
    }

    public final void addNode(N node, boolean entrypoint) {
        this.adjacencyMatrix.addNode(node);
        if (entrypoint) {
            this.entrypoints.add(node);
        }
    }

    public void addEdge(E edge) {
        this.adjacencyMatrix.addEdge(edge);
    }

    public final int getNodesCount() {
        return this.getNodes().size();
    }

    public final int getEdgesCount() {
        return this.getEdges().size();
    }

    public final E getEdgeConnecting(N source, N destination) {
        return this.adjacencyMatrix.getEdgeConnecting(source, destination);
    }

    public final Collection<E> getIngoingEdges(N node) {
        return this.adjacencyMatrix.getIngoingEdges(node);
    }

    public final Collection<E> getOutgoingEdges(N node) {
        return this.adjacencyMatrix.getOutgoingEdges(node);
    }

    public final Collection<N> followersOf(N node) {
        return this.adjacencyMatrix.followersOf(node);
    }

    public final Collection<N> predecessorsOf(N node) {
        return this.adjacencyMatrix.predecessorsOf(node);
    }

    public void dump(Writer writer) throws IOException {
        this.dump(writer, node -> "");
    }

    public void dump(Writer writer, Function<N, String> labelGenerator) throws IOException {
        this.toDot(labelGenerator).dumpDot(writer);
    }

    protected abstract DotGraph<N, E, G> toDot(Function<N, String> var1);

    public boolean isEqualTo(G graph) {
        if (this == graph) {
            return true;
        }
        if (graph == null) {
            return false;
        }
        if (this.getClass() != graph.getClass()) {
            return false;
        }
        if (this.entrypoints == null ? ((Graph)graph).entrypoints != null : !this.entrypoints.equals(((Graph)graph).entrypoints)) {
            return false;
        }
        return !(this.adjacencyMatrix == null ? ((Graph)graph).adjacencyMatrix != null : !this.adjacencyMatrix.equals(((Graph)graph).adjacencyMatrix));
    }

    public String toString() {
        return this.adjacencyMatrix.toString();
    }

    protected Set<N> simplify(Class<? extends N> target, Collection<E> removedEdges, Map<Pair<E, E>, E> replacedEdges) {
        Set<Node> targets = this.getNodes().stream().filter(k -> target.isAssignableFrom(k.getClass())).collect(Collectors.toSet());
        targets.forEach(this::preSimplify);
        this.adjacencyMatrix.simplify(targets, this.entrypoints, removedEdges, replacedEdges);
        return targets;
    }

    protected void preSimplify(N node) {
    }

    public <V> void accept(GraphVisitor<G, N, E, V> visitor, V tool) {
        if (!visitor.visit(tool, this)) {
            return;
        }
        for (Node node : this.getNodes()) {
            if (node.accept(visitor, tool)) continue;
            return;
        }
        for (Edge edge : this.getEdges()) {
            if (edge.accept(visitor, tool)) continue;
            return;
        }
    }
}

