/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;

public class FileManager {
    private final File workdir;
    private final Collection<String> createdFiles = new TreeSet<String>();
    private static final int[] illegalChars = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 47, 58, 60, 62, 63, 92, 124};

    public FileManager(String workdir) {
        this.workdir = Paths.get(workdir, new String[0]).toFile();
    }

    public Collection<String> createdFiles() {
        return this.createdFiles;
    }

    public void mkOutputFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(name, false, filler);
    }

    public void mkOutputFile(String path, String name, WriteAction filler) throws IOException {
        this.mkOutputFile(path, name, false, filler);
    }

    public void mkDotFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(FileManager.cleanupForDotFile(name) + ".dot", false, filler);
    }

    public void mkDotFile(String path, String name, WriteAction filler) throws IOException {
        this.mkOutputFile(path, FileManager.cleanupForDotFile(name) + ".dot", false, filler);
    }

    public void mkOutputFile(String name, boolean bom, WriteAction filler) throws IOException {
        this.mkOutputFile(null, name, bom, filler);
    }

    public void mkOutputFile(String path, String name, boolean bom, WriteAction filler) throws IOException {
        File parent = this.workdir;
        if (path != null) {
            parent = new File(this.workdir, FileManager.cleanFileName(path, true));
        }
        File file = new File(parent, FileManager.cleanFileName(name, false));
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory structure for " + file);
        }
        this.createdFiles.add(this.workdir.toPath().relativize(file.toPath()).toString());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8.newEncoder());){
            if (bom) {
                ((Writer)writer).write(65279);
            }
            filler.perform(writer);
        }
    }

    private static String cleanFileName(String name, boolean keepDirSeparator) {
        StringBuilder cleanName = new StringBuilder();
        int len = name.codePointCount(0, name.length());
        for (int i = 0; i < len; ++i) {
            int c = name.codePointAt(i);
            if (keepDirSeparator && (c == 57 || c == 92) || Arrays.binarySearch(illegalChars, c) < 0) {
                cleanName.appendCodePoint(c);
                continue;
            }
            cleanName.appendCodePoint(95);
        }
        return cleanName.toString();
    }

    private static String cleanupForDotFile(String name) {
        String result = name.replace(' ', '_');
        result = result.replace("::", ".");
        return result;
    }

    public static void forceDeleteFolder(String path) throws IOException {
        File workdir = new File(path);
        if (workdir.exists()) {
            FileUtils.forceDelete((File)workdir);
        }
    }

    @FunctionalInterface
    public static interface WriteAction {
        public void perform(Writer var1) throws IOException;
    }
}

