/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathNumber
implements Comparable<MathNumber> {
    public static final MathNumber PLUS_INFINITY = new MathNumber(0);
    public static final MathNumber MINUS_INFINITY = new MathNumber(1);
    public static final MathNumber ZERO = new MathNumber(0L);
    public static final MathNumber ONE = new MathNumber(1L);
    public static final MathNumber MINUS_ONE = new MathNumber(-1L);
    public static final MathNumber NaN = new MathNumber(3);
    private final BigDecimal number;
    private final byte sign;

    public MathNumber(long number) {
        this.number = BigDecimal.valueOf(number);
        this.sign = number >= 0L ? (byte)0 : 1;
    }

    public MathNumber(double number) {
        this.number = BigDecimal.valueOf(number);
        this.sign = number >= 0.0 ? (byte)0 : 1;
    }

    public MathNumber(BigDecimal number) {
        this.number = number;
        this.sign = number.signum() >= 0 ? (byte)0 : 1;
    }

    private MathNumber(byte sign) {
        this.number = null;
        this.sign = sign;
    }

    public boolean isMinusInfinity() {
        return this.number == null && this.isNegative();
    }

    public boolean isPlusInfinity() {
        return this.number == null && this.isPositiveOrZero();
    }

    public boolean isInfinite() {
        return this.isPlusInfinity() || this.isMinusInfinity();
    }

    public boolean isFinite() {
        return !this.isInfinite();
    }

    public boolean is(int n) {
        return this.number != null && this.number.equals(new BigDecimal(n));
    }

    public boolean isPositiveOrZero() {
        return this.sign == 0;
    }

    public boolean isNegative() {
        return this.sign == 1;
    }

    public boolean isNaN() {
        return this.number == null && this.sign == 3;
    }

    private static MathNumber cached(MathNumber i) {
        if (i.is(0)) {
            return ZERO;
        }
        if (i.is(1)) {
            return ONE;
        }
        if (i.is(-1)) {
            return MINUS_ONE;
        }
        return i;
    }

    public MathNumber add(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (this.isPlusInfinity() || other.isPlusInfinity()) {
            return PLUS_INFINITY;
        }
        if (this.isMinusInfinity() || other.isMinusInfinity()) {
            return MINUS_INFINITY;
        }
        return MathNumber.cached(new MathNumber(this.number.add(other.number)));
    }

    public MathNumber subtract(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (this.isPlusInfinity() || other.isPlusInfinity()) {
            return PLUS_INFINITY;
        }
        if (this.isMinusInfinity() || other.isMinusInfinity()) {
            return MINUS_INFINITY;
        }
        return MathNumber.cached(new MathNumber(this.number.subtract(other.number)));
    }

    public MathNumber multiply(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (this.is(0) || other.is(0)) {
            return ZERO;
        }
        if (this.isPlusInfinity() && other.isNegative() || other.isPlusInfinity() && this.isNegative() || this.isMinusInfinity() && other.isPositiveOrZero() || other.isMinusInfinity() && this.isPositiveOrZero()) {
            return MINUS_INFINITY;
        }
        if (this.isMinusInfinity() && other.isNegative() || other.isMinusInfinity() && this.isNegative() || this.isPlusInfinity() && other.isPositiveOrZero() || other.isPlusInfinity() && this.isPositiveOrZero()) {
            return PLUS_INFINITY;
        }
        return MathNumber.cached(new MathNumber(this.number.multiply(other.number)));
    }

    public MathNumber divide(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (other.is(0)) {
            throw new ArithmeticException("MathInt divide by zero");
        }
        if (this.is(0)) {
            return ZERO;
        }
        if (this.isInfinite() && other.isInfinite()) {
            return NaN;
        }
        if (other.isPlusInfinity() || other.isMinusInfinity()) {
            return ZERO;
        }
        if (this.isPlusInfinity() || this.isMinusInfinity()) {
            if (this.isPositiveOrZero() == other.isPositiveOrZero()) {
                return PLUS_INFINITY;
            }
            return MINUS_INFINITY;
        }
        return MathNumber.cached(new MathNumber(this.number.divide(other.number, 100, RoundingMode.HALF_UP).stripTrailingZeros()));
    }

    @Override
    public int compareTo(MathNumber other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.isNaN() && !other.isNaN()) {
            return -1;
        }
        if (!this.isNaN() && other.isNaN()) {
            return 1;
        }
        if (this.isNaN()) {
            return 0;
        }
        if (this.isMinusInfinity() || other.isPlusInfinity() || this.isNegative() && other.isPositiveOrZero()) {
            return -1;
        }
        if (this.isPlusInfinity() || other.isMinusInfinity() || this.isPositiveOrZero() && other.isNegative()) {
            return 1;
        }
        return this.number.compareTo(other.number);
    }

    public MathNumber min(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (this.isMinusInfinity() || other.isPlusInfinity()) {
            return this;
        }
        if (other.isMinusInfinity() || this.isPlusInfinity()) {
            return other;
        }
        return MathNumber.cached(new MathNumber(this.number.min(other.number)));
    }

    public MathNumber max(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (other.isMinusInfinity() || this.isPlusInfinity()) {
            return this;
        }
        if (this.isMinusInfinity() || other.isPlusInfinity()) {
            return other;
        }
        return MathNumber.cached(new MathNumber(this.number.max(other.number)));
    }

    public MathNumber roundUp() {
        if (this.isInfinite() || this.isNaN()) {
            return this;
        }
        return MathNumber.cached(new MathNumber(this.number.setScale(0, RoundingMode.CEILING)));
    }

    public MathNumber roundDown() {
        if (this.isInfinite() || this.isNaN()) {
            return this;
        }
        return MathNumber.cached(new MathNumber(this.number.setScale(0, RoundingMode.FLOOR)));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        result = 31 * result + this.sign;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MathNumber other = (MathNumber)obj;
        if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
            return false;
        }
        return this.sign == other.sign;
    }

    public String toString() {
        return this.isNaN() ? "NaN" : (this.isMinusInfinity() ? "-Inf" : (this.isPlusInfinity() ? "+Inf" : this.number.toString()));
    }
}

