/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.AnalysisException;
import it.unive.lisa.AnalysisExecutionException;
import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.LiSAConfiguration;
import it.unive.lisa.LiSAFactory;
import it.unive.lisa.LiSARunner;
import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.logging.TimerLogger;
import it.unive.lisa.outputs.JsonReport;
import it.unive.lisa.program.Program;
import it.unive.lisa.util.file.FileManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiSA {
    private static final Logger LOG = LogManager.getLogger(LiSA.class);
    private final Collection<Warning> warnings = new ArrayList<Warning>();
    private final FileManager fileManager;
    private final LiSAConfiguration conf;

    public LiSA(LiSAConfiguration conf) {
        this.conf = conf;
        this.fileManager = new FileManager(conf.getWorkdir());
    }

    public void run(Program program) throws AnalysisException {
        InterproceduralAnalysis interproc;
        CallGraph callGraph;
        this.printConfig();
        try {
            CallGraph callGraph2 = callGraph = this.conf.getCallGraph() == null ? LiSAFactory.getDefaultFor(CallGraph.class, new Object[0]) : this.conf.getCallGraph();
            if (this.conf.getCallGraph() == null) {
                LOG.warn("No call graph set for this analysis, defaulting to {}", (Object)callGraph.getClass().getSimpleName());
            }
        }
        catch (AnalysisSetupException e) {
            throw new AnalysisExecutionException("Unable to create default call graph", e);
        }
        try {
            InterproceduralAnalysis interproceduralAnalysis = interproc = this.conf.getInterproceduralAnalysis() == null ? LiSAFactory.getDefaultFor(InterproceduralAnalysis.class, new Object[0]) : this.conf.getInterproceduralAnalysis();
            if (this.conf.getInterproceduralAnalysis() == null) {
                LOG.warn("No interprocedural analysis set for this analysis, defaulting to {}", (Object)interproc.getClass().getSimpleName());
            }
        }
        catch (AnalysisSetupException e) {
            throw new AnalysisExecutionException("Unable to create default interprocedural analysis", e);
        }
        LiSARunner runner = new LiSARunner(this.conf, interproc, callGraph, this.conf.getState());
        try {
            this.warnings.addAll(TimerLogger.execSupplier(LOG, "Analysis time", () -> runner.run(program, this.fileManager)));
        }
        catch (AnalysisExecutionException e) {
            throw new AnalysisException("LiSA has encountered an exception while executing the analysis", e);
        }
        this.printStats();
        if (this.conf.isJsonOutput()) {
            LOG.info("Dumping reported warnings to 'report.json'");
            JsonReport report = new JsonReport(this.warnings, this.fileManager.createdFiles());
            try {
                this.fileManager.mkOutputFile("report.json", writer -> {
                    report.dump(writer);
                    LOG.info("Report file dumped to report.json");
                });
            }
            catch (IOException e) {
                LOG.error("Unable to dump report file", (Throwable)e);
            }
        }
    }

    private void printConfig() {
        LOG.info(this.conf.toString());
    }

    private void printStats() {
        LOG.info("LiSA statistics:");
        LOG.info("  {} warnings generated", (Object)this.warnings.size());
    }

    public Collection<Warning> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }
}

