/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.checks.semantic.SemanticCheck;
import it.unive.lisa.checks.syntactic.SyntacticCheck;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.collections.workset.FIFOWorkingSet;
import it.unive.lisa.util.collections.workset.WorkingSet;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

public class LiSAConfiguration {
    public static final int DEFAULT_WIDENING_THRESHOLD = 5;
    private final Collection<SyntacticCheck> syntacticChecks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<SemanticCheck> semanticChecks = Collections.newSetFromMap(new ConcurrentHashMap());
    private CallGraph callGraph;
    private InterproceduralAnalysis<?, ?, ?> interproceduralAnalysis;
    private AbstractState<?, ?, ?> state;
    private boolean inferTypes;
    private boolean dumpCFGs;
    private boolean dumpTypeInference;
    private boolean dumpAnalysis;
    private boolean jsonOutput;
    private String workdir = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
    private int wideningThreshold = 5;
    private Class<?> fixpointWorkingSet = FIFOWorkingSet.class;

    public LiSAConfiguration addSyntacticCheck(SyntacticCheck check) {
        this.syntacticChecks.add(check);
        return this;
    }

    public LiSAConfiguration addSyntacticChecks(Collection<SyntacticCheck> checks) {
        this.syntacticChecks.addAll(checks);
        return this;
    }

    public LiSAConfiguration addSemanticCheck(SemanticCheck check) {
        this.semanticChecks.add(check);
        return this;
    }

    public LiSAConfiguration addSemanticChecks(Collection<SemanticCheck> checks) {
        this.semanticChecks.addAll(checks);
        return this;
    }

    public LiSAConfiguration setCallGraph(CallGraph callGraph) {
        this.callGraph = callGraph;
        return this;
    }

    public LiSAConfiguration setInterproceduralAnalysis(InterproceduralAnalysis<?, ?, ?> analysis) {
        this.interproceduralAnalysis = analysis;
        return this;
    }

    public LiSAConfiguration setAbstractState(AbstractState<?, ?, ?> state) {
        this.state = state;
        return this;
    }

    public LiSAConfiguration setInferTypes(boolean inferTypes) {
        this.inferTypes = inferTypes;
        return this;
    }

    public LiSAConfiguration setDumpCFGs(boolean dumpCFGs) {
        this.dumpCFGs = dumpCFGs;
        return this;
    }

    public LiSAConfiguration setDumpTypeInference(boolean dumpTypeInference) {
        this.dumpTypeInference = dumpTypeInference;
        return this;
    }

    public LiSAConfiguration setDumpAnalysis(boolean dumpAnalysis) {
        this.dumpAnalysis = dumpAnalysis;
        return this;
    }

    public LiSAConfiguration setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
        return this;
    }

    public LiSAConfiguration setWorkdir(String workdir) {
        this.workdir = Paths.get(workdir, new String[0]).toAbsolutePath().normalize().toString();
        return this;
    }

    public LiSAConfiguration setFixpointWorkingSet(Class<? extends WorkingSet<Statement>> fixpointWorkingSet) {
        this.fixpointWorkingSet = fixpointWorkingSet;
        return this;
    }

    public LiSAConfiguration setWideningThreshold(int wideningThreshold) {
        this.wideningThreshold = wideningThreshold;
        return this;
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public InterproceduralAnalysis<?, ?, ?> getInterproceduralAnalysis() {
        return this.interproceduralAnalysis;
    }

    public AbstractState<?, ?, ?> getState() {
        return this.state;
    }

    public Collection<SyntacticCheck> getSyntacticChecks() {
        return this.syntacticChecks;
    }

    public Collection<SemanticCheck> getSemanticChecks() {
        return this.semanticChecks;
    }

    public boolean isInferTypes() {
        return this.inferTypes;
    }

    public boolean isDumpCFGs() {
        return this.dumpCFGs;
    }

    public boolean isDumpTypeInference() {
        return this.dumpTypeInference;
    }

    public boolean isDumpAnalysis() {
        return this.dumpAnalysis;
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public String getWorkdir() {
        return this.workdir;
    }

    public Class<? extends WorkingSet<Statement>> getFixpointWorkingSet() {
        return this.fixpointWorkingSet;
    }

    public int getWideningThreshold() {
        return this.wideningThreshold;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.callGraph == null ? 0 : this.callGraph.hashCode());
        result = 31 * result + (this.dumpAnalysis ? 1231 : 1237);
        result = 31 * result + (this.dumpCFGs ? 1231 : 1237);
        result = 31 * result + (this.dumpTypeInference ? 1231 : 1237);
        result = 31 * result + (this.fixpointWorkingSet == null ? 0 : this.fixpointWorkingSet.hashCode());
        result = 31 * result + (this.inferTypes ? 1231 : 1237);
        result = 31 * result + (this.interproceduralAnalysis == null ? 0 : this.interproceduralAnalysis.hashCode());
        result = 31 * result + (this.jsonOutput ? 1231 : 1237);
        result = 31 * result + (this.semanticChecks == null ? 0 : this.semanticChecks.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.syntacticChecks == null ? 0 : this.syntacticChecks.hashCode());
        result = 31 * result + this.wideningThreshold;
        result = 31 * result + (this.workdir == null ? 0 : this.workdir.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiSAConfiguration other = (LiSAConfiguration)obj;
        if (this.callGraph == null ? other.callGraph != null : !this.callGraph.equals(other.callGraph)) {
            return false;
        }
        if (this.dumpAnalysis != other.dumpAnalysis) {
            return false;
        }
        if (this.dumpCFGs != other.dumpCFGs) {
            return false;
        }
        if (this.dumpTypeInference != other.dumpTypeInference) {
            return false;
        }
        if (this.fixpointWorkingSet == null ? other.fixpointWorkingSet != null : !this.fixpointWorkingSet.equals(other.fixpointWorkingSet)) {
            return false;
        }
        if (this.inferTypes != other.inferTypes) {
            return false;
        }
        if (this.interproceduralAnalysis == null ? other.interproceduralAnalysis != null : !this.interproceduralAnalysis.equals(other.interproceduralAnalysis)) {
            return false;
        }
        if (this.jsonOutput != other.jsonOutput) {
            return false;
        }
        if (this.semanticChecks == null ? other.semanticChecks != null : !this.semanticChecks.equals(other.semanticChecks)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.syntacticChecks == null ? other.syntacticChecks != null : !this.syntacticChecks.equals(other.syntacticChecks)) {
            return false;
        }
        if (this.wideningThreshold != other.wideningThreshold) {
            return false;
        }
        return !(this.workdir == null ? other.workdir != null : !this.workdir.equals(other.workdir));
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("LiSA configuration:").append("\n  workdir: ").append(String.valueOf(this.workdir)).append("\n  dump input cfgs: ").append(this.dumpCFGs).append("\n  infer types: ").append(this.inferTypes).append("\n  dump inferred types: ").append(this.dumpTypeInference).append("\n  dump analysis results: ").append(this.dumpAnalysis).append("\n  dump json report: ").append(this.jsonOutput).append("\n  ").append(this.syntacticChecks.size()).append(" syntactic checks to execute").append(this.syntacticChecks.isEmpty() ? "" : ":");
        for (SyntacticCheck syntacticCheck : this.syntacticChecks) {
            res.append("\n      ").append(syntacticCheck.getClass().getSimpleName());
        }
        res.append("\n  ").append(this.semanticChecks.size()).append(" semantic checks to execute").append(this.semanticChecks.isEmpty() ? "" : ":");
        for (SemanticCheck semanticCheck : this.semanticChecks) {
            res.append("\n      ").append(semanticCheck.getClass().getSimpleName());
        }
        return res.toString();
    }
}

