/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.DefaultImplementation;
import it.unive.lisa.DefaultParameters;
import it.unive.lisa.LiSA;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.dataflow.DataflowElement;
import it.unive.lisa.analysis.dataflow.DefiniteForwardDataflowDomain;
import it.unive.lisa.analysis.dataflow.PossibleForwardDataflowDomain;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;

public final class LiSAFactory {
    private static final Map<Class<?>, Class<?>> CUSTOM_DEFAULTS = new HashMap();

    private LiSAFactory() {
    }

    private static <T> T construct(Class<T> component, Class<?>[] argTypes, Object[] params) throws AnalysisSetupException {
        try {
            Constructor<T> constructor = component.getConstructor(argTypes);
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AnalysisSetupException("Unable to instantiate " + component.getSimpleName(), e);
        }
    }

    private static Class<?>[] findConstructorSignature(Class<?> component, Object[] params) throws AnalysisSetupException {
        IdentityHashMap candidates = new IdentityHashMap();
        block0: for (Constructor<?> constructor : component.getConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            if (params.length != types.length) continue;
            ArrayList<Integer> toWrap = new ArrayList<Integer>();
            for (int i = 0; i < types.length; ++i) {
                if (LiSAFactory.needsWrapping(params[i].getClass(), types[i])) {
                    toWrap.add(i);
                    continue;
                }
                if (!types[i].isAssignableFrom(params[i].getClass())) continue block0;
            }
            candidates.put(constructor, toWrap);
        }
        if (candidates.isEmpty()) {
            throw new AnalysisSetupException("No suitable constructor of " + component.getSimpleName() + " found for argument types " + Arrays.toString(Arrays.stream(params).map(Object::getClass).toArray(Class[]::new)));
        }
        if (candidates.size() > 1) {
            throw new AnalysisSetupException("Constructor call of " + component.getSimpleName() + " is ambiguous for argument types " + Arrays.toString(Arrays.stream(params).map(Object::getClass).toArray(Class[]::new)));
        }
        Iterator iterator = ((List)candidates.values().iterator().next()).iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            params[p] = LiSAFactory.wrapParam(params[p]);
        }
        return ((Constructor)candidates.keySet().iterator().next()).getParameterTypes();
    }

    private static boolean needsWrapping(Class<?> actual, Class<?> desired) {
        if (NonRelationalHeapDomain.class.isAssignableFrom(actual) && desired.isAssignableFrom(HeapDomain.class)) {
            return true;
        }
        if (NonRelationalValueDomain.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class)) {
            return true;
        }
        if (InferredValue.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class)) {
            return true;
        }
        return DataflowElement.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class);
    }

    private static Object wrapParam(Object param) {
        if (NonRelationalHeapDomain.class.isAssignableFrom(param.getClass())) {
            return new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)param);
        }
        if (NonRelationalValueDomain.class.isAssignableFrom(param.getClass())) {
            return new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)param);
        }
        if (InferredValue.class.isAssignableFrom(param.getClass())) {
            return new InferenceSystem<InferredValue>((InferredValue)param);
        }
        if (DataflowElement.class.isAssignableFrom(param.getClass())) {
            Class<?> elem = param.getClass();
            if (elem.getGenericInterfaces().length == 0) {
                return param;
            }
            for (Type gi : elem.getGenericInterfaces()) {
                if (!(gi instanceof ParameterizedType) || ((ParameterizedType)gi).getRawType() != DataflowElement.class) continue;
                Type domain = ((ParameterizedType)gi).getActualTypeArguments()[0];
                if (((ParameterizedType)domain).getRawType() == PossibleForwardDataflowDomain.class) {
                    return new PossibleForwardDataflowDomain<DataflowElement>((DataflowElement)param);
                }
                if (((ParameterizedType)domain).getRawType() == DefiniteForwardDataflowDomain.class) {
                    return new DefiniteForwardDataflowDomain<DataflowElement>((DataflowElement)param);
                }
                return param;
            }
        }
        return param;
    }

    public static <T> T getInstance(Class<T> component, Object ... params) throws AnalysisSetupException {
        try {
            if (params != null && params.length != 0) {
                return LiSAFactory.construct(component, LiSAFactory.findConstructorSignature(component, params), params);
            }
            DefaultParameters defaultParams = component.getAnnotation(DefaultParameters.class);
            if (defaultParams == null) {
                return LiSAFactory.construct(component, ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_OBJECT_ARRAY);
            }
            Object[] defaults = new Object[defaultParams.value().length];
            for (int i = 0; i < defaults.length; ++i) {
                defaults[i] = LiSAFactory.getInstance(defaultParams.value()[i], new Object[0]);
            }
            return LiSAFactory.construct(component, LiSAFactory.findConstructorSignature(component, defaults), defaults);
        }
        catch (NullPointerException e) {
            throw new AnalysisSetupException("Unable to instantiate default " + component.getSimpleName(), e);
        }
    }

    public static void registerDefaultFor(Class<?> component, Class<?> defaultImplementation) {
        CUSTOM_DEFAULTS.put(component, defaultImplementation);
    }

    private static <T> Class<? extends T> getDefaultClassFor(Class<T> component) {
        if (CUSTOM_DEFAULTS.containsKey(component)) {
            return CUSTOM_DEFAULTS.get(component);
        }
        DefaultImplementation defaultImpl = component.getAnnotation(DefaultImplementation.class);
        if (defaultImpl == null) {
            return null;
        }
        return defaultImpl.value();
    }

    public static <T> T getDefaultFor(Class<T> component, Object ... params) throws AnalysisSetupException {
        try {
            Class<T> def = LiSAFactory.getDefaultClassFor(component);
            if (LiSAFactory.needsWrapping(def, component)) {
                return (T)LiSAFactory.wrapParam(LiSAFactory.getInstance(def, params));
            }
            return LiSAFactory.getInstance(def, params);
        }
        catch (NullPointerException e) {
            throw new AnalysisSetupException("Unable to instantiate default " + component.getSimpleName(), e);
        }
    }

    public static Collection<ConfigurableComponent<?>> configurableComponents() {
        ArrayList in = new ArrayList();
        in.add(new ConfigurableComponent<CallGraph>(CallGraph.class));
        in.add(new ConfigurableComponent<AbstractState>(AbstractState.class));
        in.add(new ConfigurableComponent<HeapDomain>(HeapDomain.class));
        in.add(new ConfigurableComponent<ValueDomain>(ValueDomain.class));
        in.add(new ConfigurableComponent<NonRelationalHeapDomain>(NonRelationalHeapDomain.class));
        in.add(new ConfigurableComponent<NonRelationalValueDomain>(NonRelationalValueDomain.class));
        return in;
    }

    public static final class ConfigurableComponent<T> {
        private static final Reflections scanner = new Reflections(new Object[]{LiSA.class, new SubTypesScanner()});
        private final Class<T> component;
        private final Class<? extends T> defaultInstance;
        private final Collection<Class<? extends T>> alternatives;

        private ConfigurableComponent(Class<T> component) {
            this.component = component;
            this.defaultInstance = LiSAFactory.getDefaultClassFor(component);
            this.alternatives = scanner.getSubTypesOf(component).stream().map(c -> Pair.of((Object)c, (Object)c.getModifiers())).filter(p -> !Modifier.isAbstract((Integer)p.getRight()) && !Modifier.isInterface((Integer)p.getRight())).map(p -> (Class)p.getLeft()).collect(Collectors.toList());
        }

        public Class<T> getComponent() {
            return this.component;
        }

        public Class<? extends T> getDefaultInstance() {
            return this.defaultInstance;
        }

        public Collection<Class<? extends T>> getAlternatives() {
            return this.alternatives;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alternatives == null ? 0 : this.alternatives.hashCode());
            result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
            result = 31 * result + (this.defaultInstance == null ? 0 : this.defaultInstance.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigurableComponent other = (ConfigurableComponent)obj;
            if (this.alternatives == null ? other.alternatives != null : !this.alternatives.equals(other.alternatives)) {
                return false;
            }
            if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
                return false;
            }
            return !(this.defaultInstance == null ? other.defaultInstance != null : !this.defaultInstance.equals(other.defaultInstance));
        }

        public String toString() {
            return this.component.getName() + "(defaults to: '" + this.defaultInstance.getName() + "', alternatives: " + this.alternatives + ")";
        }
    }
}

