/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.AnalysisExecutionException;
import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.LiSAConfiguration;
import it.unive.lisa.LiSAFactory;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.CFGWithAnalysisResults;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SimpleAbstractState;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.types.InferredTypes;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.checks.ChecksExecutor;
import it.unive.lisa.checks.semantic.CheckToolWithAnalysisResults;
import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallGraphConstructionException;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.logging.TimerLogger;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.SyntheticLocation;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import it.unive.lisa.util.file.FileManager;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiSARunner<A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> {
    private static final String FIXPOINT_EXCEPTION_MESSAGE = "Exception during fixpoint computation";
    private static final Logger LOG = LogManager.getLogger(LiSARunner.class);
    private final LiSAConfiguration conf;
    private final InterproceduralAnalysis<A, H, V> interproc;
    private final CallGraph callGraph;
    private final A state;

    LiSARunner(LiSAConfiguration conf, InterproceduralAnalysis<A, H, V> interproc, CallGraph callGraph, A state) {
        this.conf = conf;
        this.interproc = interproc;
        this.callGraph = callGraph;
        this.state = state;
    }

    Collection<Warning> run(Program program, FileManager fileManager) {
        LiSARunner.finalizeProgram(program);
        Collection<CFG> allCFGs = program.getAllCFGs();
        if (this.conf.isDumpCFGs()) {
            for (CFG cfg : IterationLogger.iterate(LOG, allCFGs, "Dumping input CFGs", "cfgs")) {
                LiSARunner.dumpCFG(fileManager, "", cfg, st -> "");
            }
        }
        CheckToolWithAnalysisResults tool = new CheckToolWithAnalysisResults();
        if (!this.conf.getSyntacticChecks().isEmpty()) {
            ChecksExecutor.executeAll(tool, program, this.conf.getSyntacticChecks());
        } else {
            LOG.warn("Skipping syntactic checks execution since none have been provided");
        }
        try {
            this.callGraph.init(program);
        }
        catch (CallGraphConstructionException e) {
            LOG.fatal("Exception while building the call graph for the input program", (Throwable)e);
            throw new AnalysisExecutionException("Exception while building the call graph for the input program", e);
        }
        try {
            this.interproc.init(program, this.callGraph);
        }
        catch (InterproceduralAnalysisException e) {
            LOG.fatal("Exception while building the interprocedural analysis for the input program", (Throwable)e);
            throw new AnalysisExecutionException("Exception while building the interprocedural analysis for the input program", e);
        }
        if (this.conf.isInferTypes()) {
            this.inferTypes(fileManager, program, allCFGs);
        } else {
            LOG.warn("Type inference disabled: dynamic type information will not be available for following analysis");
        }
        if (this.state != null) {
            this.analyze(allCFGs, fileManager);
            IdentityHashMap results = new IdentityHashMap(allCFGs.size());
            for (CFG cfg : allCFGs) {
                results.put(cfg, this.interproc.getAnalysisResultsOf(cfg));
            }
            if (!this.conf.getSemanticChecks().isEmpty()) {
                CheckToolWithAnalysisResults toolWithResults;
                tool = toolWithResults = new CheckToolWithAnalysisResults(tool, results);
                ChecksExecutor.executeAll(toolWithResults, program, this.conf.getSemanticChecks());
            } else {
                LOG.warn("Skipping semantic checks execution since none have been provided");
            }
        } else {
            LOG.warn("Skipping analysis execution since no abstract sate has been provided");
        }
        return tool.getWarnings();
    }

    private void analyze(Collection<CFG> allCFGs, FileManager fileManager) {
        AbstractState state = (AbstractState)this.state.top();
        TimerLogger.execAction(LOG, "Computing fixpoint over the whole program", () -> {
            try {
                this.interproc.fixpoint(new AnalysisState(state, new Skip(SyntheticLocation.INSTANCE)), this.conf.getFixpointWorkingSet(), this.conf.getWideningThreshold());
            }
            catch (FixpointException e) {
                LOG.fatal(FIXPOINT_EXCEPTION_MESSAGE, (Throwable)e);
                throw new AnalysisExecutionException(FIXPOINT_EXCEPTION_MESSAGE, e);
            }
        });
        if (this.conf.isDumpAnalysis()) {
            for (CFG cfg : IterationLogger.iterate(LOG, allCFGs, "Dumping analysis results", "cfgs")) {
                for (CFGWithAnalysisResults result : this.interproc.getAnalysisResultsOf(cfg)) {
                    LiSARunner.dumpCFG(fileManager, "analysis___" + (String)(result.getId() == null ? "" : result.getId().hashCode() + "_"), result, st -> result.getAnalysisStateAfter((Statement)st).toString());
                }
            }
        }
    }

    private void inferTypes(FileManager fileManager, Program program, Collection<CFG> allCFGs) {
        InterproceduralAnalysis typesInterproc;
        Lattice typesState;
        try {
            InferenceSystem<InferredTypes> types = new InferenceSystem<InferredTypes>(new InferredTypes());
            Object heap = this.state == null ? LiSAFactory.getDefaultFor(HeapDomain.class, new Object[0]) : this.state.getHeapState();
            typesState = LiSAFactory.getInstance(SimpleAbstractState.class, heap, types).top();
            typesInterproc = (InterproceduralAnalysis)LiSAFactory.getInstance(this.interproc.getClass(), new Object[0]);
            typesInterproc.init(program, this.callGraph);
        }
        catch (AnalysisSetupException | InterproceduralAnalysisException e) {
            throw new AnalysisExecutionException("Unable to initialize type inference", e);
        }
        TimerLogger.execAction(LOG, "Computing type information", () -> this.lambda$inferTypes$3(typesInterproc, (SimpleAbstractState)typesState));
        String message = this.conf.isDumpTypeInference() ? "Dumping type analysis and propagating it to cfgs" : "Propagating type information to cfgs";
        for (CFG cfg : IterationLogger.iterate(LOG, allCFGs, message, "cfgs")) {
            Collection results = typesInterproc.getAnalysisResultsOf(cfg);
            if (results.isEmpty()) {
                LOG.warn("No type information computed for '{}': it is unreachable", (Object)cfg);
                continue;
            }
            CFGWithAnalysisResults result = null;
            try {
                for (CFGWithAnalysisResults res : results) {
                    if (result == null) {
                        result = res;
                        continue;
                    }
                    result = result.join(res);
                }
            }
            catch (SemanticException e) {
                throw new AnalysisExecutionException("Unable to compute type information for " + cfg, e);
            }
            cfg.accept(new TypesPropagator(), result);
            CFGWithAnalysisResults r = result;
            if (!this.conf.isDumpTypeInference()) continue;
            LiSARunner.dumpCFG(fileManager, "typing___", r, st -> r.getAnalysisStateAfter((Statement)st).toString());
        }
    }

    private static void finalizeProgram(Program program) {
        Caches.types().clear();
        ExternalSet<Type> types = Caches.types().mkEmptySet();
        program.getRegisteredTypes().forEach(types::add);
        types = null;
        TimerLogger.execAction(LOG, "Finalizing input program", () -> {
            try {
                program.validateAndFinalize();
            }
            catch (ProgramValidationException e) {
                throw new AnalysisExecutionException("Unable to finalize target program", e);
            }
        });
    }

    private static void dumpCFG(FileManager fileManager, String filePrefix, CFG cfg, Function<Statement, String> labelGenerator) {
        try {
            fileManager.mkDotFile(filePrefix + cfg.getDescriptor().getFullSignatureWithParNames(), writer -> cfg.dump(writer, labelGenerator::apply));
        }
        catch (IOException e) {
            LOG.error("Exception while dumping the analysis results on {}", (Object)cfg.getDescriptor().getFullSignature());
            LOG.error((Object)e);
        }
    }

    private /* synthetic */ void lambda$inferTypes$3(InterproceduralAnalysis typesInterproc, SimpleAbstractState typesState) {
        try {
            typesInterproc.fixpoint(new AnalysisState(typesState, new Skip(SyntheticLocation.INSTANCE)), this.conf.getFixpointWorkingSet(), this.conf.getWideningThreshold());
        }
        catch (FixpointException e) {
            LOG.fatal(FIXPOINT_EXCEPTION_MESSAGE, (Throwable)e);
            throw new AnalysisExecutionException(FIXPOINT_EXCEPTION_MESSAGE, e);
        }
    }

    private static class TypesPropagator<A extends AbstractState<A, H, InferenceSystem<InferredTypes>>, H extends HeapDomain<H>>
    implements GraphVisitor<CFG, Statement, Edge, CFGWithAnalysisResults<A, H, InferenceSystem<InferredTypes>>> {
        private TypesPropagator() {
        }

        @Override
        public boolean visit(CFGWithAnalysisResults<A, H, InferenceSystem<InferredTypes>> tool, CFG graph) {
            return true;
        }

        @Override
        public boolean visit(CFGWithAnalysisResults<A, H, InferenceSystem<InferredTypes>> tool, CFG graph, Edge edge) {
            return true;
        }

        @Override
        public boolean visit(CFGWithAnalysisResults<A, H, InferenceSystem<InferredTypes>> tool, CFG graph, Statement node) {
            if (tool != null && node instanceof Expression) {
                ((Expression)node).setRuntimeTypes(((InferredTypes)((InferenceSystem)tool.getAnalysisStateAfter(node).getState().getValueState()).getInferredValue()).getRuntimeTypes());
            }
            return true;
        }
    }
}

