/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.SetRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class AnalysisState<A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>>
extends BaseLattice<AnalysisState<A, H, V>>
implements SemanticDomain<AnalysisState<A, H, V>, SymbolicExpression, Identifier> {
    private final A state;
    private final ExpressionSet<SymbolicExpression> computedExpressions;

    public AnalysisState(A state, SymbolicExpression computedExpression) {
        this(state, new ExpressionSet<SymbolicExpression>(computedExpression));
    }

    public AnalysisState(A state, ExpressionSet<SymbolicExpression> computedExpressions) {
        this.state = state;
        this.computedExpressions = computedExpressions;
    }

    public A getState() {
        return this.state;
    }

    public ExpressionSet<SymbolicExpression> getComputedExpressions() {
        return this.computedExpressions;
    }

    @Override
    public AnalysisState<A, H, V> assign(Identifier id, SymbolicExpression value, ProgramPoint pp) throws SemanticException {
        AbstractState s = (AbstractState)this.state.assign((Identifier)id, (SymbolicExpression)value, pp);
        return new AnalysisState<AbstractState, H, V>(s, new ExpressionSet<SymbolicExpression>(id));
    }

    @Override
    public AnalysisState<A, H, V> assign(SymbolicExpression id, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        if (id instanceof Identifier) {
            return this.assign((Identifier)id, expression, pp);
        }
        AbstractState s = (AbstractState)this.state.bottom();
        ExpressionSet<SymbolicExpression> rewritten = this.rewrite(id, pp);
        for (SymbolicExpression i : rewritten) {
            s = s.lub((AbstractState)this.state.assign((Identifier)((Identifier)i), (SymbolicExpression)expression, pp));
        }
        return new AnalysisState<AbstractState, H, V>(s, rewritten);
    }

    @Override
    public AnalysisState<A, H, V> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        AbstractState s = (AbstractState)this.state.smallStepSemantics((SymbolicExpression)expression, pp);
        return new AnalysisState<AbstractState, H, V>(s, new ExpressionSet<SymbolicExpression>(expression));
    }

    private ExpressionSet<SymbolicExpression> rewrite(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return new ExpressionSet<SymbolicExpression>(this.getState().getHeapState().rewrite(expression, pp).elements().stream().map(SymbolicExpression.class::cast).collect(Collectors.toSet()));
    }

    @Override
    public AnalysisState<A, H, V> assume(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return new AnalysisState<AbstractState, H, V>((AbstractState)this.state.assume((SymbolicExpression)expression, pp), this.computedExpressions);
    }

    @Override
    public SemanticDomain.Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return this.state.satisfies((SymbolicExpression)expression, pp);
    }

    @Override
    public AnalysisState<A, H, V> pushScope(ScopeToken scope) throws SemanticException {
        return new AnalysisState<AbstractState, H, V>((AbstractState)this.state.pushScope(scope), AnalysisState.onAllExpressions(this.computedExpressions, scope, true));
    }

    private static ExpressionSet<SymbolicExpression> onAllExpressions(ExpressionSet<SymbolicExpression> computedExpressions, ScopeToken scope, boolean push) throws SemanticException {
        HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
        for (SymbolicExpression exp : computedExpressions) {
            result.add(push ? exp.pushScope(scope) : exp.popScope(scope));
        }
        return new ExpressionSet<SymbolicExpression>((Set<SymbolicExpression>)result);
    }

    @Override
    public AnalysisState<A, H, V> popScope(ScopeToken scope) throws SemanticException {
        return new AnalysisState<AbstractState, H, V>((AbstractState)this.state.popScope(scope), AnalysisState.onAllExpressions(this.computedExpressions, scope, false));
    }

    @Override
    public AnalysisState<A, H, V> lubAux(AnalysisState<A, H, V> other) throws SemanticException {
        return new AnalysisState<AbstractState, H, V>((AbstractState)this.state.lub(other.state), this.computedExpressions.lub(other.computedExpressions));
    }

    @Override
    public AnalysisState<A, H, V> wideningAux(AnalysisState<A, H, V> other) throws SemanticException {
        return new AnalysisState<AbstractState, H, V>((AbstractState)this.state.widening(other.state), this.computedExpressions.lub(other.computedExpressions));
    }

    @Override
    public boolean lessOrEqualAux(AnalysisState<A, H, V> other) throws SemanticException {
        return this.state.lessOrEqual(other.state);
    }

    @Override
    public AnalysisState<A, H, V> top() {
        return new AnalysisState<AbstractState, H, V>((AbstractState)this.state.top(), new ExpressionSet<SymbolicExpression>());
    }

    @Override
    public AnalysisState<A, H, V> bottom() {
        return new AnalysisState<AbstractState, H, V>((AbstractState)this.state.bottom(), new ExpressionSet<SymbolicExpression>());
    }

    @Override
    public boolean isTop() {
        return this.state.isTop();
    }

    @Override
    public boolean isBottom() {
        return this.state.isBottom();
    }

    @Override
    public AnalysisState<A, H, V> forgetIdentifier(Identifier id) throws SemanticException {
        return new AnalysisState<AbstractState, H, V>((AbstractState)this.state.forgetIdentifier(id), this.computedExpressions);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.computedExpressions == null ? 0 : this.computedExpressions.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisState other = (AnalysisState)obj;
        if (this.computedExpressions == null ? other.computedExpressions != null : !this.computedExpressions.equals(other.computedExpressions)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    @Override
    public DomainRepresentation representation() {
        return new AnalysisStateRepresentation(this.state.representation(), new SetRepresentation(this.computedExpressions.elements(), StringRepresentation::new));
    }

    @Override
    public String toString() {
        return this.representation().toString();
    }

    private static final class AnalysisStateRepresentation
    extends DomainRepresentation {
        private final DomainRepresentation state;
        private final DomainRepresentation expressions;

        private AnalysisStateRepresentation(DomainRepresentation state, DomainRepresentation expressions) {
            this.state = state;
            this.expressions = expressions;
        }

        @Override
        public String toString() {
            return "{{\n" + this.state + "\n}} -> " + this.expressions;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expressions == null ? 0 : this.expressions.hashCode());
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnalysisStateRepresentation other = (AnalysisStateRepresentation)obj;
            if (this.expressions == null ? other.expressions != null : !this.expressions.equals(other.expressions)) {
                return false;
            }
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }
    }
}

