/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;

public interface SemanticDomain<D extends SemanticDomain<D, E, I>, E extends SymbolicExpression, I extends Identifier> {
    public D assign(I var1, E var2, ProgramPoint var3) throws SemanticException;

    public D smallStepSemantics(E var1, ProgramPoint var2) throws SemanticException;

    public D assume(E var1, ProgramPoint var2) throws SemanticException;

    public D forgetIdentifier(Identifier var1) throws SemanticException;

    default public D forgetIdentifiers(Iterable<Identifier> ids) throws SemanticException {
        SemanticDomain<D, E, I> result = this;
        for (Identifier id : ids) {
            result = result.forgetIdentifier(id);
        }
        return (D)result;
    }

    public Satisfiability satisfies(E var1, ProgramPoint var2) throws SemanticException;

    public D pushScope(ScopeToken var1) throws SemanticException;

    public D popScope(ScopeToken var1) throws SemanticException;

    public DomainRepresentation representation();

    public static enum Satisfiability implements Lattice<Satisfiability>
    {
        SATISFIED{

            @Override
            public Satisfiability negate() {
                return NOT_SATISFIED;
            }

            @Override
            public Satisfiability and(Satisfiability other) {
                return other;
            }

            @Override
            public Satisfiability or(Satisfiability other) {
                return this;
            }

            @Override
            public Satisfiability lub(Satisfiability other) throws SemanticException {
                if (other == UNKNOWN || other == NOT_SATISFIED) {
                    return UNKNOWN;
                }
                return this;
            }

            @Override
            public Satisfiability widening(Satisfiability other) throws SemanticException {
                return this.lub(other);
            }

            @Override
            public boolean lessOrEqual(Satisfiability other) throws SemanticException {
                return other == this || other == UNKNOWN;
            }

            @Override
            public Satisfiability glb(Satisfiability other) {
                if (other == BOTTOM || other == NOT_SATISFIED) {
                    return BOTTOM;
                }
                return this;
            }
        }
        ,
        NOT_SATISFIED{

            @Override
            public Satisfiability negate() {
                return SATISFIED;
            }

            @Override
            public Satisfiability and(Satisfiability other) {
                return this;
            }

            @Override
            public Satisfiability or(Satisfiability other) {
                return other;
            }

            @Override
            public Satisfiability lub(Satisfiability other) throws SemanticException {
                if (other == UNKNOWN || other == SATISFIED) {
                    return UNKNOWN;
                }
                return this;
            }

            @Override
            public Satisfiability widening(Satisfiability other) throws SemanticException {
                return this.lub(other);
            }

            @Override
            public boolean lessOrEqual(Satisfiability other) throws SemanticException {
                return other == this || other == UNKNOWN;
            }

            @Override
            public Satisfiability glb(Satisfiability other) {
                if (other == BOTTOM || other == SATISFIED) {
                    return BOTTOM;
                }
                return this;
            }
        }
        ,
        UNKNOWN{

            @Override
            public Satisfiability negate() {
                return this;
            }

            @Override
            public Satisfiability and(Satisfiability other) {
                if (other == NOT_SATISFIED) {
                    return other;
                }
                return this;
            }

            @Override
            public Satisfiability or(Satisfiability other) {
                if (other == SATISFIED) {
                    return other;
                }
                return this;
            }

            @Override
            public Satisfiability lub(Satisfiability other) throws SemanticException {
                return this;
            }

            @Override
            public Satisfiability widening(Satisfiability other) throws SemanticException {
                return this;
            }

            @Override
            public boolean lessOrEqual(Satisfiability other) throws SemanticException {
                return other == UNKNOWN;
            }

            @Override
            public Satisfiability glb(Satisfiability other) {
                return other;
            }
        }
        ,
        BOTTOM{

            @Override
            public Satisfiability negate() {
                return this;
            }

            @Override
            public Satisfiability and(Satisfiability other) {
                return this;
            }

            @Override
            public Satisfiability or(Satisfiability other) {
                return this;
            }

            @Override
            public Satisfiability lub(Satisfiability other) throws SemanticException {
                return other;
            }

            @Override
            public Satisfiability widening(Satisfiability other) throws SemanticException {
                return other;
            }

            @Override
            public boolean lessOrEqual(Satisfiability other) throws SemanticException {
                return true;
            }

            @Override
            public Satisfiability glb(Satisfiability other) {
                return this;
            }
        };


        public abstract Satisfiability negate();

        public abstract Satisfiability and(Satisfiability var1);

        public abstract Satisfiability or(Satisfiability var1);

        public abstract Satisfiability glb(Satisfiability var1);

        public static Satisfiability fromBoolean(boolean bool) {
            return bool ? SATISFIED : NOT_SATISFIED;
        }

        @Override
        public Satisfiability top() {
            return UNKNOWN;
        }

        @Override
        public Satisfiability bottom() {
            return BOTTOM;
        }
    }
}

