/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.DefaultParameters;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.impl.heap.MonolithicHeap;
import it.unive.lisa.analysis.impl.numeric.Interval;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;

@DefaultParameters(value={MonolithicHeap.class, Interval.class})
public class SimpleAbstractState<H extends HeapDomain<H>, V extends ValueDomain<V>>
extends BaseLattice<SimpleAbstractState<H, V>>
implements AbstractState<SimpleAbstractState<H, V>, H, V> {
    private final H heapState;
    private final V valueState;

    public SimpleAbstractState(H heapState, V valueState) {
        this.heapState = heapState;
        this.valueState = valueState;
    }

    @Override
    public H getHeapState() {
        return this.heapState;
    }

    @Override
    public V getValueState() {
        return this.valueState;
    }

    @Override
    public SimpleAbstractState<H, V> assign(Identifier id, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        HeapDomain heap = (HeapDomain)this.heapState.assign((Identifier)id, (SymbolicExpression)expression, pp);
        ExpressionSet<ValueExpression> exprs = heap.rewrite(expression, pp);
        Object value = this.valueState;
        if (heap.getSubstitution() != null && !heap.getSubstitution().isEmpty()) {
            value = value.applySubstitution(heap.getSubstitution(), pp);
        }
        for (ValueExpression expr : exprs) {
            value = (ValueDomain)value.assign((Identifier)id, (ValueExpression)expr, pp);
        }
        return new SimpleAbstractState<HeapDomain, V>(heap, value);
    }

    @Override
    public SimpleAbstractState<H, V> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        HeapDomain heap = (HeapDomain)this.heapState.smallStepSemantics((SymbolicExpression)expression, pp);
        ExpressionSet<ValueExpression> exprs = heap.rewrite(expression, pp);
        Object value = this.valueState;
        if (heap.getSubstitution() != null && !heap.getSubstitution().isEmpty()) {
            value = value.applySubstitution(heap.getSubstitution(), pp);
        }
        for (ValueExpression expr : exprs) {
            value = (ValueDomain)value.smallStepSemantics((ValueExpression)expr, pp);
        }
        return new SimpleAbstractState<HeapDomain, V>(heap, value);
    }

    @Override
    public SimpleAbstractState<H, V> assume(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        HeapDomain heap = (HeapDomain)this.heapState.assume((SymbolicExpression)expression, pp);
        ExpressionSet<ValueExpression> exprs = heap.rewrite(expression, pp);
        Object value = this.valueState;
        if (heap.getSubstitution() != null && !heap.getSubstitution().isEmpty()) {
            value = value.applySubstitution(heap.getSubstitution(), pp);
        }
        for (ValueExpression expr : exprs) {
            value = (ValueDomain)value.assume((ValueExpression)expr, pp);
        }
        return new SimpleAbstractState<HeapDomain, V>(heap, value);
    }

    @Override
    public SemanticDomain.Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        ExpressionSet<ValueExpression> rewritten = this.heapState.rewrite(expression, pp);
        SemanticDomain.Satisfiability result = SemanticDomain.Satisfiability.BOTTOM;
        for (ValueExpression expr : rewritten) {
            result = result.lub(this.valueState.satisfies((ValueExpression)expr, pp));
        }
        return this.heapState.satisfies((SymbolicExpression)expression, pp).glb(result);
    }

    @Override
    public SimpleAbstractState<H, V> pushScope(ScopeToken scope) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain>((HeapDomain)this.heapState.pushScope(scope), (ValueDomain)this.valueState.pushScope(scope));
    }

    @Override
    public SimpleAbstractState<H, V> popScope(ScopeToken scope) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain>((HeapDomain)this.heapState.popScope(scope), (ValueDomain)this.valueState.popScope(scope));
    }

    @Override
    public SimpleAbstractState<H, V> lubAux(SimpleAbstractState<H, V> other) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain>((HeapDomain)this.heapState.lub(other.heapState), (ValueDomain)this.valueState.lub(other.valueState));
    }

    @Override
    public SimpleAbstractState<H, V> wideningAux(SimpleAbstractState<H, V> other) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain>((HeapDomain)this.heapState.widening(other.heapState), (ValueDomain)this.valueState.widening(other.valueState));
    }

    @Override
    public boolean lessOrEqualAux(SimpleAbstractState<H, V> other) throws SemanticException {
        return this.heapState.lessOrEqual(other.heapState) && this.valueState.lessOrEqual(other.valueState);
    }

    @Override
    public SimpleAbstractState<H, V> top() {
        return new SimpleAbstractState<HeapDomain, ValueDomain>((HeapDomain)this.heapState.top(), (ValueDomain)this.valueState.top());
    }

    @Override
    public SimpleAbstractState<H, V> bottom() {
        return new SimpleAbstractState<HeapDomain, ValueDomain>((HeapDomain)this.heapState.bottom(), (ValueDomain)this.valueState.bottom());
    }

    @Override
    public boolean isTop() {
        return this.heapState.isTop() && this.valueState.isTop();
    }

    @Override
    public boolean isBottom() {
        return this.heapState.isBottom() && this.valueState.isBottom();
    }

    @Override
    public SimpleAbstractState<H, V> forgetIdentifier(Identifier id) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain>((HeapDomain)this.heapState.forgetIdentifier(id), (ValueDomain)this.valueState.forgetIdentifier(id));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.heapState == null ? 0 : this.heapState.hashCode());
        result = 31 * result + (this.valueState == null ? 0 : this.valueState.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleAbstractState other = (SimpleAbstractState)obj;
        if (this.heapState == null ? other.heapState != null : !this.heapState.equals(other.heapState)) {
            return false;
        }
        return !(this.valueState == null ? other.valueState != null : !this.valueState.equals(other.valueState));
    }

    @Override
    public DomainRepresentation representation() {
        return new StateRepresentation(this.heapState.representation(), this.valueState.representation());
    }

    @Override
    public String toString() {
        return this.representation().toString();
    }

    private static final class StateRepresentation
    extends DomainRepresentation {
        private final DomainRepresentation heap;
        private final DomainRepresentation value;

        private StateRepresentation(DomainRepresentation heap, DomainRepresentation value) {
            this.heap = heap;
            this.value = value;
        }

        @Override
        public String toString() {
            return "heap [[ " + this.heap + " ]]\nvalue [[ " + this.value + " ]]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.heap == null ? 0 : this.heap.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StateRepresentation other = (StateRepresentation)obj;
            if (this.heap == null ? other.heap != null : !this.heap.equals(other.heap)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

