/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.dataflow;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.dataflow.DataflowElement;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.SetRepresentation;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public abstract class DataflowDomain<D extends DataflowDomain<D, E>, E extends DataflowElement<D, E>>
extends BaseLattice<D>
implements ValueDomain<D> {
    private final boolean isTop;
    private final boolean isBottom;
    private final Set<E> elements;
    protected final E domain;

    protected DataflowDomain(E domain, Set<E> elements, boolean isTop, boolean isBottom) {
        this.elements = elements;
        this.domain = domain;
        this.isTop = isTop;
        this.isBottom = isBottom;
    }

    protected abstract D mk(E var1, Set<E> var2, boolean var3, boolean var4);

    @Override
    public final D assign(Identifier id, ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return this.update(() -> !this.domain.tracksIdentifiers(id) || !this.domain.canProcess(expression), () -> this.domain.gen(id, expression, pp, (DataflowDomain)this), () -> this.domain.kill(id, expression, pp, (DataflowDomain)this));
    }

    @Override
    public final D smallStepSemantics(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return this.update(() -> !this.domain.canProcess(expression), () -> this.domain.gen(expression, pp, (DataflowDomain)this), () -> this.domain.kill(expression, pp, (DataflowDomain)this));
    }

    private D update(BooleanSupplier guard, Supplier<Collection<E>> gen, Supplier<Collection<E>> kill) {
        if (this.isBottom()) {
            return (D)this;
        }
        if (guard.getAsBoolean()) {
            return (D)this;
        }
        HashSet<DataflowElement> updated = new HashSet<DataflowElement>(this.getDataflowElements());
        for (DataflowElement killed : kill.get()) {
            updated.remove(killed);
        }
        for (DataflowElement generated : gen.get()) {
            updated.add(generated);
        }
        return this.mk(this.domain, updated, false, false);
    }

    @Override
    public final D assume(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return (D)this;
    }

    @Override
    public final D forgetIdentifier(Identifier id) throws SemanticException {
        if (this.isTop()) {
            return (D)this;
        }
        LinkedList<DataflowElement> toRemove = new LinkedList<DataflowElement>();
        for (DataflowElement e : this.elements) {
            if (!e.getInvolvedIdentifiers().contains(id)) continue;
            toRemove.add(e);
        }
        if (toRemove.isEmpty()) {
            return (D)this;
        }
        HashSet<E> updated = new HashSet<E>(this.elements);
        updated.removeAll(toRemove);
        return this.mk(this.domain, updated, false, false);
    }

    @Override
    public final SemanticDomain.Satisfiability satisfies(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.isBottom ? 1231 : 1237);
        result = 31 * result + (this.isTop ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataflowDomain other = (DataflowDomain)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        if (this.isBottom != other.isBottom) {
            return false;
        }
        return this.isTop == other.isTop;
    }

    @Override
    public final DomainRepresentation representation() {
        return new SetRepresentation(this.elements, DataflowElement::representation);
    }

    @Override
    public final D top() {
        return this.mk(this.domain, new HashSet(), true, false);
    }

    @Override
    public final boolean isTop() {
        return this.elements.isEmpty() && this.isTop;
    }

    @Override
    public final D bottom() {
        return this.mk(this.domain, new HashSet(), false, true);
    }

    @Override
    public final boolean isBottom() {
        return this.elements.isEmpty() && this.isBottom;
    }

    public final Set<E> getDataflowElements() {
        return this.elements;
    }

    @Override
    public final D pushScope(ScopeToken scope) throws SemanticException {
        if (this.isTop() || this.isBottom()) {
            return (D)this;
        }
        HashSet result = new HashSet();
        for (DataflowElement element : this.elements) {
            Object pushed = element.pushScope(scope);
            if (pushed == null) continue;
            result.add(pushed);
        }
        return this.mk(this.domain, result, false, false);
    }

    @Override
    public final D popScope(ScopeToken scope) throws SemanticException {
        if (this.isTop() || this.isBottom()) {
            return (D)this;
        }
        HashSet result = new HashSet();
        for (DataflowElement element : this.elements) {
            Object popped = element.popScope(scope);
            if (popped == null) continue;
            result.add(popped);
        }
        return this.mk(this.domain, result, false, false);
    }

    @Override
    protected final D wideningAux(D other) throws SemanticException {
        return (D)((DataflowDomain)this.lubAux(other));
    }

    @Override
    public final String toString() {
        return this.representation().toString();
    }
}

