/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.impl.heap;

import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.BaseHeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.SetRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapAllocation;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.value.HeapLocation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;

public class TypeBasedHeap
extends BaseHeapDomain<TypeBasedHeap> {
    private static final TypeBasedHeap TOP = new TypeBasedHeap();
    private static final TypeBasedHeap BOTTOM = new TypeBasedHeap();
    private final Set<String> names;

    public TypeBasedHeap() {
        this(new HashSet<String>());
    }

    private TypeBasedHeap(Set<String> names) {
        this.names = names;
    }

    @Override
    public ExpressionSet<ValueExpression> rewrite(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return expression.accept(new Rewriter(), pp);
    }

    @Override
    public TypeBasedHeap assign(Identifier id, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return this;
    }

    @Override
    public TypeBasedHeap assume(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return this;
    }

    @Override
    public TypeBasedHeap forgetIdentifier(Identifier id) throws SemanticException {
        return this;
    }

    @Override
    public SemanticDomain.Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    public DomainRepresentation representation() {
        return new SetRepresentation(this.names, StringRepresentation::new);
    }

    @Override
    public TypeBasedHeap top() {
        return TOP;
    }

    @Override
    public TypeBasedHeap bottom() {
        return BOTTOM;
    }

    @Override
    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return Collections.emptyList();
    }

    @Override
    protected TypeBasedHeap mk(TypeBasedHeap reference) {
        return this;
    }

    @Override
    protected TypeBasedHeap semanticsOf(HeapExpression expression, ProgramPoint pp) throws SemanticException {
        if (expression instanceof AccessChild) {
            AccessChild access = (AccessChild)expression;
            TypeBasedHeap containerState = (TypeBasedHeap)this.smallStepSemantics(access.getContainer(), pp);
            return (TypeBasedHeap)containerState.smallStepSemantics(access.getChild(), pp);
        }
        if (expression instanceof HeapAllocation) {
            HashSet<String> names = new HashSet<String>(this.names);
            for (Type type : expression.getTypes()) {
                if (!type.isPointerType()) continue;
                names.add(type.toString());
            }
            return new TypeBasedHeap(names);
        }
        if (expression instanceof HeapReference) {
            return (TypeBasedHeap)this.smallStepSemantics(((HeapReference)expression).getExpression(), pp);
        }
        if (expression instanceof HeapDereference) {
            return (TypeBasedHeap)this.smallStepSemantics(((HeapDereference)expression).getExpression(), pp);
        }
        return this.top();
    }

    @Override
    protected TypeBasedHeap lubAux(TypeBasedHeap other) throws SemanticException {
        return new TypeBasedHeap((Set<String>)SetUtils.union(this.names, other.names));
    }

    @Override
    protected TypeBasedHeap wideningAux(TypeBasedHeap other) throws SemanticException {
        return this.lubAux(other);
    }

    @Override
    protected boolean lessOrEqualAux(TypeBasedHeap other) throws SemanticException {
        return other.names.containsAll(this.names);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeBasedHeap other = (TypeBasedHeap)obj;
        return !(this.names == null ? other.names != null : !this.names.equals(other.names));
    }

    private static class Rewriter
    extends BaseHeapDomain.Rewriter {
        private Rewriter() {
        }

        @Override
        public ExpressionSet<ValueExpression> visit(AccessChild expression, ExpressionSet<ValueExpression> receiver, ExpressionSet<ValueExpression> child, Object ... params) throws SemanticException {
            ExternalSet<Type> types = expression.getTypes();
            HashSet<HeapLocation> result = new HashSet<HeapLocation>();
            for (ValueExpression rec : receiver) {
                if (!(rec instanceof MemoryPointer)) continue;
                MemoryPointer pid = (MemoryPointer)rec;
                for (Type t : pid.getTypes()) {
                    if (!t.isPointerType()) continue;
                    result.add(new HeapLocation(types, t.toString(), true, expression.getCodeLocation()));
                }
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(HeapAllocation expression, Object ... params) throws SemanticException {
            ExternalSet<Type> types = expression.getTypes();
            HashSet<HeapLocation> result = new HashSet<HeapLocation>();
            for (Type t : types) {
                if (!t.isPointerType()) continue;
                result.add(new HeapLocation(types, t.toString(), true, expression.getCodeLocation()));
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(HeapReference expression, ExpressionSet<ValueExpression> ref, Object ... params) throws SemanticException {
            HashSet<MemoryPointer> result = new HashSet<MemoryPointer>();
            for (ValueExpression refExp : ref) {
                if (!(refExp instanceof HeapLocation)) continue;
                result.add(new MemoryPointer(expression.getTypes(), (HeapLocation)refExp, refExp.getCodeLocation()));
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(HeapDereference expression, ExpressionSet<ValueExpression> deref, Object ... params) throws SemanticException {
            HashSet<MemoryPointer> result = new HashSet<MemoryPointer>();
            for (ValueExpression derefExp : deref) {
                if (!(derefExp instanceof Variable)) continue;
                Variable v = (Variable)derefExp;
                ExternalSet<Type> types = v.getTypes();
                for (Type t : types) {
                    if (!t.isPointerType()) continue;
                    result.add(new MemoryPointer(types, new HeapLocation(types, t.toString(), true, v.getCodeLocation()), v.getCodeLocation()));
                }
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }
    }
}

