/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.impl.heap.pointbased;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.impl.heap.pointbased.AllocationSite;
import it.unive.lisa.analysis.impl.heap.pointbased.AllocationSites;
import it.unive.lisa.analysis.impl.heap.pointbased.PointBasedHeap;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapAllocation;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.HashSet;
import java.util.Set;

public class FieldSensitivePointBasedHeap
extends PointBasedHeap {
    public FieldSensitivePointBasedHeap() {
    }

    private FieldSensitivePointBasedHeap(HeapEnvironment<AllocationSites> allocationSites) {
        super(allocationSites);
    }

    @Override
    protected FieldSensitivePointBasedHeap from(PointBasedHeap original) {
        return new FieldSensitivePointBasedHeap(original.heapEnv);
    }

    @Override
    public ExpressionSet<ValueExpression> rewrite(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return expression.accept(new Rewriter(), new Object[0]);
    }

    private class Rewriter
    extends PointBasedHeap.Rewriter {
        private Rewriter() {
            super(FieldSensitivePointBasedHeap.this);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(AccessChild expression, ExpressionSet<ValueExpression> receiver, ExpressionSet<ValueExpression> child, Object ... params) throws SemanticException {
            HashSet<AllocationSite> result = new HashSet<AllocationSite>();
            for (ValueExpression contRewritten : receiver) {
                if (!(contRewritten instanceof MemoryPointer)) continue;
                AllocationSite site = (AllocationSite)((MemoryPointer)contRewritten).getReferencedLocation();
                for (SymbolicExpression symbolicExpression : child) {
                    result.add(new AllocationSite(expression.getTypes(), site.getLocationName(), symbolicExpression, site.isWeak(), site.getCodeLocation()));
                }
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(HeapAllocation expression, Object ... params) throws SemanticException {
            String pp = expression.getCodeLocation().getCodeLocation();
            if (this.alreadyAllocated(pp) != null) {
                return new ExpressionSet<ValueExpression>(new AllocationSite(expression.getTypes(), pp, true, expression.getCodeLocation()));
            }
            return new ExpressionSet<ValueExpression>(new AllocationSite(expression.getTypes(), pp, false, expression.getCodeLocation()));
        }

        private AllocationSite alreadyAllocated(String id) {
            for (AllocationSites set : FieldSensitivePointBasedHeap.this.heapEnv.getValues()) {
                for (AllocationSite site : set) {
                    if (!site.getLocationName().equals(id)) continue;
                    return site;
                }
            }
            return null;
        }
    }
}

