/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.impl.heap.pointbased;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.BaseHeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.impl.heap.pointbased.AllocationSite;
import it.unive.lisa.analysis.impl.heap.pointbased.AllocationSites;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.SetRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapAllocation;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.value.HeapLocation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PointBasedHeap
extends BaseHeapDomain<PointBasedHeap> {
    protected final HeapEnvironment<AllocationSites> heapEnv;

    public PointBasedHeap() {
        this(new HeapEnvironment<AllocationSites>(new AllocationSites()));
    }

    protected PointBasedHeap(HeapEnvironment<AllocationSites> heapEnv) {
        this.heapEnv = heapEnv;
    }

    protected PointBasedHeap from(PointBasedHeap original) {
        return original;
    }

    @Override
    public PointBasedHeap assign(Identifier id, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        PointBasedHeap sss = (PointBasedHeap)this.smallStepSemantics(expression, pp);
        ExpressionSet<ValueExpression> rewrittenExp = sss.rewrite(expression, pp);
        PointBasedHeap result = this.bottom();
        for (ValueExpression exp : rewrittenExp) {
            if (exp instanceof MemoryPointer) {
                MemoryPointer pid = (MemoryPointer)exp;
                Identifier v = id instanceof MemoryPointer ? ((MemoryPointer)id).getReferencedLocation() : id;
                HeapEnvironment heap = (HeapEnvironment)sss.heapEnv.assign(v, pid.getReferencedLocation(), pp);
                result = result.lub(this.from(new PointBasedHeap(heap)));
                continue;
            }
            result = result.lub(sss);
        }
        return result;
    }

    @Override
    public PointBasedHeap assume(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return (PointBasedHeap)this.smallStepSemantics(expression, pp);
    }

    @Override
    public PointBasedHeap forgetIdentifier(Identifier id) throws SemanticException {
        return this.from(new PointBasedHeap((HeapEnvironment)this.heapEnv.forgetIdentifier(id)));
    }

    @Override
    public SemanticDomain.Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        HashSet<HeapLocation> res = new HashSet<HeapLocation>();
        for (Identifier id : this.heapEnv.getKeys()) {
            for (HeapLocation hid : (AllocationSites)this.heapEnv.getState(id)) {
                res.add(hid);
            }
        }
        return new SetRepresentation(res, StringRepresentation::new);
    }

    @Override
    public PointBasedHeap top() {
        return this.from(new PointBasedHeap((HeapEnvironment<AllocationSites>)this.heapEnv.top()));
    }

    @Override
    public boolean isTop() {
        return this.heapEnv.isTop();
    }

    @Override
    public PointBasedHeap bottom() {
        return this.from(new PointBasedHeap((HeapEnvironment<AllocationSites>)this.heapEnv.bottom()));
    }

    @Override
    public boolean isBottom() {
        return this.heapEnv.isBottom();
    }

    @Override
    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return Collections.emptyList();
    }

    @Override
    public PointBasedHeap mk(PointBasedHeap reference) {
        return this.from(new PointBasedHeap(reference.heapEnv));
    }

    @Override
    protected PointBasedHeap lubAux(PointBasedHeap other) throws SemanticException {
        return this.from(new PointBasedHeap(this.heapEnv.lub(other.heapEnv)));
    }

    @Override
    protected PointBasedHeap wideningAux(PointBasedHeap other) throws SemanticException {
        return this.lubAux(other);
    }

    @Override
    protected boolean lessOrEqualAux(PointBasedHeap other) throws SemanticException {
        return this.heapEnv.lessOrEqual(other.heapEnv);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.heapEnv == null ? 0 : this.heapEnv.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointBasedHeap other = (PointBasedHeap)obj;
        return !(this.heapEnv == null ? other.heapEnv != null : !this.heapEnv.equals(other.heapEnv));
    }

    @Override
    protected PointBasedHeap semanticsOf(HeapExpression expression, ProgramPoint pp) throws SemanticException {
        return this;
    }

    @Override
    public ExpressionSet<ValueExpression> rewrite(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return expression.accept(new Rewriter(), new Object[0]);
    }

    @Override
    public PointBasedHeap popScope(ScopeToken scope) throws SemanticException {
        return this.from(new PointBasedHeap((HeapEnvironment)this.heapEnv.popScope(scope)));
    }

    @Override
    public PointBasedHeap pushScope(ScopeToken scope) throws SemanticException {
        return this.from(new PointBasedHeap((HeapEnvironment)this.heapEnv.pushScope(scope)));
    }

    protected class Rewriter
    extends BaseHeapDomain.Rewriter {
        protected Rewriter() {
        }

        @Override
        public ExpressionSet<ValueExpression> visit(AccessChild expression, ExpressionSet<ValueExpression> receiver, ExpressionSet<ValueExpression> child, Object ... params) throws SemanticException {
            HashSet<AllocationSite> result = new HashSet<AllocationSite>();
            for (ValueExpression rec : receiver) {
                if (!(rec instanceof MemoryPointer)) continue;
                MemoryPointer pid = (MemoryPointer)rec;
                AllocationSite site = (AllocationSite)pid.getReferencedLocation();
                result.add(new AllocationSite(expression.getTypes(), site.getLocationName(), true, expression.getCodeLocation()));
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(HeapAllocation expression, Object ... params) throws SemanticException {
            AllocationSite id = new AllocationSite(expression.getTypes(), expression.getCodeLocation().getCodeLocation(), true, expression.getCodeLocation());
            return new ExpressionSet<ValueExpression>(id);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(HeapReference expression, ExpressionSet<ValueExpression> loc, Object ... params) throws SemanticException {
            HashSet<ValueExpression> result = new HashSet<ValueExpression>();
            for (ValueExpression locExp : loc) {
                if (locExp instanceof AllocationSite) {
                    result.add(new MemoryPointer(locExp.getTypes(), (AllocationSite)locExp, locExp.getCodeLocation()));
                    continue;
                }
                result.add(locExp);
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(HeapDereference expression, ExpressionSet<ValueExpression> ref, Object ... params) throws SemanticException {
            HashSet<ValueExpression> result = new HashSet<ValueExpression>();
            for (ValueExpression refExp : ref) {
                if (refExp instanceof Identifier && !(refExp instanceof MemoryPointer)) {
                    Identifier id = (Identifier)refExp;
                    if (!PointBasedHeap.this.heapEnv.getKeys().contains(id)) continue;
                    result.addAll(this.resolveIdentifier(id));
                    continue;
                }
                result.add(refExp);
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public final ExpressionSet<ValueExpression> visit(Identifier expression, Object ... params) throws SemanticException {
            if (!(expression instanceof MemoryPointer) && PointBasedHeap.this.heapEnv.getKeys().contains(expression)) {
                return new ExpressionSet<ValueExpression>(this.resolveIdentifier(expression));
            }
            return new ExpressionSet<ValueExpression>(expression);
        }

        private Set<ValueExpression> resolveIdentifier(Identifier v) {
            HashSet<ValueExpression> result = new HashSet<ValueExpression>();
            for (AllocationSite site : (AllocationSites)PointBasedHeap.this.heapEnv.getState(v)) {
                result.add(new MemoryPointer(site.getTypes(), site, site.getCodeLocation()));
            }
            return result;
        }
    }
}

