/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.impl.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryOperator;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.TernaryOperator;
import it.unive.lisa.symbolic.value.UnaryOperator;
import it.unive.lisa.symbolic.value.ValueExpression;

public class IntegerConstantPropagation
extends BaseNonRelationalValueDomain<IntegerConstantPropagation> {
    private static final IntegerConstantPropagation TOP = new IntegerConstantPropagation(true, false);
    private static final IntegerConstantPropagation BOTTOM = new IntegerConstantPropagation(false, true);
    private final boolean isTop;
    private final boolean isBottom;
    private final Integer value;

    public IntegerConstantPropagation() {
        this(null, true, false);
    }

    private IntegerConstantPropagation(Integer value, boolean isTop, boolean isBottom) {
        this.value = value;
        this.isTop = isTop;
        this.isBottom = isBottom;
    }

    private IntegerConstantPropagation(Integer value) {
        this(value, false, false);
    }

    private IntegerConstantPropagation(boolean isTop, boolean isBottom) {
        this(null, isTop, isBottom);
    }

    @Override
    public IntegerConstantPropagation top() {
        return TOP;
    }

    @Override
    public boolean isTop() {
        return this.isTop;
    }

    @Override
    public IntegerConstantPropagation bottom() {
        return BOTTOM;
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        return new StringRepresentation(this.value.toString());
    }

    @Override
    protected IntegerConstantPropagation evalNullConstant(ProgramPoint pp) {
        return this.top();
    }

    @Override
    protected IntegerConstantPropagation evalNonNullConstant(Constant constant, ProgramPoint pp) {
        if (constant.getValue() instanceof Integer) {
            return new IntegerConstantPropagation((Integer)constant.getValue());
        }
        return this.top();
    }

    @Override
    protected IntegerConstantPropagation evalUnaryExpression(UnaryOperator operator, IntegerConstantPropagation arg, ProgramPoint pp) {
        if (arg.isTop()) {
            return this.top();
        }
        switch (operator) {
            case NUMERIC_NEG: {
                return new IntegerConstantPropagation(-this.value.intValue());
            }
        }
        return this.top();
    }

    @Override
    protected IntegerConstantPropagation evalBinaryExpression(BinaryOperator operator, IntegerConstantPropagation left, IntegerConstantPropagation right, ProgramPoint pp) {
        switch (operator) {
            case NUMERIC_ADD: {
                return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(left.value + right.value);
            }
            case NUMERIC_DIV: {
                if (!left.isTop() && left.value == 0) {
                    return new IntegerConstantPropagation(0);
                }
                if (!right.isTop() && right.value == 0) {
                    return this.bottom();
                }
                if (left.isTop() || right.isTop() || left.value % right.value != 0) {
                    return this.top();
                }
                return new IntegerConstantPropagation(left.value / right.value);
            }
            case NUMERIC_MOD: {
                return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(left.value % right.value);
            }
            case NUMERIC_MUL: {
                return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(left.value * right.value);
            }
            case NUMERIC_SUB: {
                return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(left.value - right.value);
            }
        }
        return this.top();
    }

    @Override
    protected IntegerConstantPropagation evalTernaryExpression(TernaryOperator operator, IntegerConstantPropagation left, IntegerConstantPropagation middle, IntegerConstantPropagation right, ProgramPoint pp) {
        return this.top();
    }

    @Override
    protected IntegerConstantPropagation lubAux(IntegerConstantPropagation other) throws SemanticException {
        return TOP;
    }

    @Override
    protected IntegerConstantPropagation wideningAux(IntegerConstantPropagation other) throws SemanticException {
        return this.lubAux(other);
    }

    @Override
    protected boolean lessOrEqualAux(IntegerConstantPropagation other) throws SemanticException {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isBottom ? 1231 : 1237);
        result = 31 * result + (this.isTop ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerConstantPropagation other = (IntegerConstantPropagation)obj;
        if (this.isBottom != other.isBottom) {
            return false;
        }
        if (this.isTop != other.isTop) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, IntegerConstantPropagation left, IntegerConstantPropagation right, ProgramPoint pp) {
        if (left.isTop() || right.isTop()) {
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        switch (operator) {
            case COMPARISON_EQ: {
                return left.value.intValue() == right.value.intValue() ? SemanticDomain.Satisfiability.SATISFIED : SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
            case COMPARISON_GE: {
                return left.value >= right.value ? SemanticDomain.Satisfiability.SATISFIED : SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
            case COMPARISON_GT: {
                return left.value > right.value ? SemanticDomain.Satisfiability.SATISFIED : SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
            case COMPARISON_LE: {
                return left.value <= right.value ? SemanticDomain.Satisfiability.SATISFIED : SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
            case COMPARISON_LT: {
                return left.value < right.value ? SemanticDomain.Satisfiability.SATISFIED : SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
            case COMPARISON_NE: {
                return left.value.intValue() != right.value.intValue() ? SemanticDomain.Satisfiability.SATISFIED : SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    protected ValueEnvironment<IntegerConstantPropagation> assumeBinaryExpression(ValueEnvironment<IntegerConstantPropagation> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint pp) throws SemanticException {
        switch (operator) {
            case COMPARISON_EQ: {
                if (left instanceof Identifier) {
                    environment = (ValueEnvironment)environment.assign((Identifier)left, right, pp);
                } else if (right instanceof Identifier) {
                    environment = (ValueEnvironment)environment.assign((Identifier)right, left, pp);
                }
                return environment;
            }
        }
        return environment;
    }
}

