/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.impl.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryOperator;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.UnaryOperator;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;

public class Interval
extends BaseNonRelationalValueDomain<Interval> {
    private static final Interval ZERO = new Interval(IntInterval.ZERO);
    private static final Interval TOP = new Interval(IntInterval.INFINITY);
    private static final Interval BOTTOM = new Interval(null);
    final IntInterval interval;

    private Interval(IntInterval interval) {
        this.interval = interval;
    }

    private Interval(MathNumber low, MathNumber high) {
        this(new IntInterval(low, high));
    }

    public Interval() {
        this(IntInterval.INFINITY);
    }

    @Override
    public Interval top() {
        return TOP;
    }

    @Override
    public boolean isTop() {
        return this.interval != null && this.interval.isInfinity();
    }

    @Override
    public Interval bottom() {
        return BOTTOM;
    }

    @Override
    public boolean isBottom() {
        return this.interval == null;
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        return new StringRepresentation(this.interval.toString());
    }

    @Override
    protected Interval evalNonNullConstant(Constant constant, ProgramPoint pp) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return new Interval(new MathNumber(i.intValue()), new MathNumber(i.intValue()));
        }
        return this.top();
    }

    @Override
    protected Interval evalUnaryExpression(UnaryOperator operator, Interval arg, ProgramPoint pp) {
        switch (operator) {
            case NUMERIC_NEG: {
                if (arg.isTop()) {
                    return this.top();
                }
                return new Interval(arg.interval.mul(IntInterval.MINUS_ONE));
            }
            case STRING_LENGTH: {
                return new Interval(MathNumber.ZERO, MathNumber.PLUS_INFINITY);
            }
        }
        return this.top();
    }

    private boolean is(int n) {
        return !this.isBottom() && this.interval.is(n);
    }

    @Override
    protected Interval evalBinaryExpression(BinaryOperator operator, Interval left, Interval right, ProgramPoint pp) {
        if (operator != BinaryOperator.NUMERIC_DIV && (left.isTop() || right.isTop())) {
            return this.top();
        }
        switch (operator) {
            case NUMERIC_ADD: {
                return new Interval(left.interval.plus(right.interval));
            }
            case NUMERIC_SUB: {
                return new Interval(left.interval.diff(right.interval));
            }
            case NUMERIC_MUL: {
                if (left.is(0) || right.is(0)) {
                    return ZERO;
                }
                return new Interval(left.interval.mul(right.interval));
            }
            case NUMERIC_DIV: {
                if (right.is(0)) {
                    return this.bottom();
                }
                if (left.is(0)) {
                    return ZERO;
                }
                if (left.isTop() || right.isTop()) {
                    return this.top();
                }
                return new Interval(left.interval.div(right.interval, false, false));
            }
        }
        return this.top();
    }

    @Override
    protected Interval lubAux(Interval other) throws SemanticException {
        MathNumber newLow = this.interval.getLow().min(other.interval.getLow());
        MathNumber newHigh = this.interval.getHigh().max(other.interval.getHigh());
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    @Override
    protected Interval glbAux(Interval other) {
        MathNumber newHigh;
        MathNumber newLow = this.interval.getLow().max(other.interval.getLow());
        if (newLow.compareTo(newHigh = this.interval.getHigh().min(other.interval.getHigh())) > 0) {
            return this.bottom();
        }
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    @Override
    protected Interval wideningAux(Interval other) throws SemanticException {
        MathNumber newHigh = other.interval.getHigh().compareTo(this.interval.getHigh()) > 0 ? MathNumber.PLUS_INFINITY : this.interval.getHigh();
        MathNumber newLow = other.interval.getLow().compareTo(this.interval.getLow()) < 0 ? MathNumber.MINUS_INFINITY : this.interval.getLow();
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    @Override
    protected boolean lessOrEqualAux(Interval other) throws SemanticException {
        return other.interval.includes(this.interval);
    }

    @Override
    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, Interval left, Interval right, ProgramPoint pp) {
        if (left.isTop() || right.isTop()) {
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        switch (operator) {
            case COMPARISON_EQ: {
                Interval glb = null;
                try {
                    glb = left.glb(right);
                }
                catch (SemanticException e) {
                    return SemanticDomain.Satisfiability.UNKNOWN;
                }
                if (glb.isBottom()) {
                    return SemanticDomain.Satisfiability.NOT_SATISFIED;
                }
                if (left.interval.isSingleton() && left.equals(right)) {
                    return SemanticDomain.Satisfiability.SATISFIED;
                }
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            case COMPARISON_GE: {
                return this.satisfiesBinaryExpression(BinaryOperator.COMPARISON_LE, right, left, pp);
            }
            case COMPARISON_GT: {
                return this.satisfiesBinaryExpression(BinaryOperator.COMPARISON_LT, right, left, pp);
            }
            case COMPARISON_LE: {
                Interval glb = null;
                try {
                    glb = left.glb(right);
                }
                catch (SemanticException e) {
                    return SemanticDomain.Satisfiability.UNKNOWN;
                }
                if (glb.isBottom()) {
                    return SemanticDomain.Satisfiability.fromBoolean(left.interval.getHigh().compareTo(right.interval.getLow()) <= 0);
                }
                if (glb.interval.isSingleton() && left.interval.getHigh().compareTo(right.interval.getLow()) == 0) {
                    return SemanticDomain.Satisfiability.SATISFIED;
                }
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            case COMPARISON_LT: {
                Interval glb = null;
                try {
                    glb = left.glb(right);
                }
                catch (SemanticException e) {
                    return SemanticDomain.Satisfiability.UNKNOWN;
                }
                if (glb.isBottom()) {
                    return SemanticDomain.Satisfiability.fromBoolean(left.interval.getHigh().compareTo(right.interval.getLow()) < 0);
                }
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            case COMPARISON_NE: {
                Interval glb = null;
                try {
                    glb = left.glb(right);
                }
                catch (SemanticException e) {
                    return SemanticDomain.Satisfiability.UNKNOWN;
                }
                if (glb.isBottom()) {
                    return SemanticDomain.Satisfiability.SATISFIED;
                }
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return !(this.interval == null ? other.interval != null : !this.interval.equals(other.interval));
    }

    @Override
    protected ValueEnvironment<Interval> assumeBinaryExpression(ValueEnvironment<Interval> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint pp) throws SemanticException {
        boolean rightIsExpr;
        Identifier id;
        Interval eval;
        if (left instanceof Identifier) {
            eval = this.eval(right, environment, pp);
            id = (Identifier)left;
            rightIsExpr = true;
        } else if (right instanceof Identifier) {
            eval = this.eval(left, environment, pp);
            id = (Identifier)right;
            rightIsExpr = false;
        } else {
            return environment;
        }
        if (eval.isBottom()) {
            return environment.bottom();
        }
        boolean lowIsMinusInfinity = eval.interval.lowIsMinusInfinity();
        Interval low_inf = new Interval(eval.interval.getLow(), MathNumber.PLUS_INFINITY);
        Interval lowp1_inf = new Interval(eval.interval.getLow().add(MathNumber.ONE), MathNumber.PLUS_INFINITY);
        Interval inf_high = new Interval(MathNumber.MINUS_INFINITY, eval.interval.getHigh());
        Interval inf_highm1 = new Interval(MathNumber.MINUS_INFINITY, eval.interval.getHigh().subtract(MathNumber.ONE));
        switch (operator) {
            case COMPARISON_EQ: {
                return (ValueEnvironment)environment.putState(id, eval);
            }
            case COMPARISON_GE: {
                if (rightIsExpr) {
                    return lowIsMinusInfinity ? environment : (ValueEnvironment)environment.putState(id, low_inf);
                }
                return (ValueEnvironment)environment.putState(id, inf_high);
            }
            case COMPARISON_GT: {
                if (rightIsExpr) {
                    return lowIsMinusInfinity ? environment : (ValueEnvironment)environment.putState(id, lowp1_inf);
                }
                return (ValueEnvironment)environment.putState(id, lowIsMinusInfinity ? eval : inf_highm1);
            }
            case COMPARISON_LE: {
                if (rightIsExpr) {
                    return (ValueEnvironment)environment.putState(id, inf_high);
                }
                return lowIsMinusInfinity ? environment : (ValueEnvironment)environment.putState(id, low_inf);
            }
            case COMPARISON_LT: {
                if (rightIsExpr) {
                    return (ValueEnvironment)environment.putState(id, lowIsMinusInfinity ? eval : inf_highm1);
                }
                return lowIsMinusInfinity ? environment : (ValueEnvironment)environment.putState(id, lowp1_inf);
            }
        }
        return environment;
    }
}

